/* Global External Registers */
/* ************************* */

extern struct MotorFlags
	{
		unsigned RunMotor 	:1u;
		unsigned Direction	:1u;
		unsigned SystemTest :1u;
		unsigned Delay_Ramps_Flag :1u;
		unsigned Motor_Fault_RPM_Flag :1u;
		unsigned Motor_Fault_Current_Flag :1u;
		unsigned Motor_Fault_Av_Current_Flag :1u;
		unsigned Motor_Fault_Ext_Comparator_Flag : 1u;
		unsigned unused		:8u;
	} Flags;

extern volatile uint16_t FlagsShort;

extern volatile uint16_t instantaneous_rpm;					/* RPM Value without filtering */
extern volatile uint16_t average_rpm;						/* RPM Value with filtering */
extern volatile uint16_t RPM_target;						/* Target RPM from demand pot or I2C */
extern volatile uint16_t instantaneous_motor_current;		/* Motor current without filtering, 0 - 1023*/
extern volatile uint16_t average_motor_current;				/* Motor current with filtering, 0 - 1023 */
extern volatile uint16_t instantaneous_vbus;				/* Vbus voltage without filering, 0 - 1023 */
extern volatile uint16_t average_vbus;						/* Vbus value with filtering, 0 - 1023 */
extern volatile uint16_t instantaneous_demand_pot;			/* Demand pot without filtering, 0 - 1023 */
extern volatile uint16_t average_demand_pot;				/* Demand pot with filtering, 0 - 1023 */

extern volatile uint16_t motor_ramp_up_speed;				/* Parameter comes from I2C packet */
extern volatile uint16_t motor_ramp_down_speed;				/* Parameter comes from I2C packet */
extern volatile uint16_t motor_demand_forward_speed;		/* Parameter comes from I2C packet */
extern volatile uint16_t motor_demand_reverse_speed;		/* Parameter comes from I2C packet */
extern volatile uint16_t actual_speed;						/* Motor speed controlled via I2C packet */


extern volatile uint16_t HallValue;							/* Latest value of hall sensors input */
extern volatile uint32_t timer3value;						/* Last value of period of revolution */
extern volatile uint32_t timer3avg;							/* Average period of rotation */
extern volatile uint8_t polecount;							/* Current pole count as shaft rotates */
extern volatile uint16_t TMR3_Additional_High;				/* Additional word for timer 3 - makes it a 32 bit counter/timer */

/* Sequence Table For Hall Effects */
extern uint16_t StateTableFwd[];							/* Output state table of PWM outputs - Forward direction */
extern uint16_t StateTableRev[];							/* Output state table of PWM outputs - Forward direction */


extern volatile uint8_t current_state;
