/* ASC1/UART1 Configuration for RS-EDP Board */
/* ***************************************** */

/* Configure ASC1/UART1 for General Purpose UART, using mbed libraries */


/* Includes Here */
#include "mbed.h"
#include "misra_types.h"                /* Standard Misra Types For ARM */
#include "mbed_Port_Structure.h"        /* mbed module port structure and port functions */



/* function Prototypes Defined Here */
void setup_UART1(void);
uint16_t UART1_Receieve_Byte(void);




/* Setup UART1 */
void setup_UART1(void)                                                                 /* Configure UART1 */
    {

        /*
             UART1 configured as follow:
             - Word Length = 8 Bits
             - One Stop Bit
             - No parity
             - BaudRate = 115200 baud
             - Hardware flow control disabled (no RTS nor CTS signals)
             - Receive and transmit enabled
        */
  
          UART1.baud(115000);
          UART1.format(8,Serial::None,1);

    }



/* UART0 Receieve Routine */
uint16_t UART1_Receieve_Byte(void)
    {
        return 0;    
    }


