/* Driver for the MAX1x3x Serial ADC */
/* ********************************* */

/* Version 2.00 */
/* Last Ammend Date: 23/6/09 */


#define _MAX1038_



/* Include Files Here */
#include "mbed.h"                                /* mbed header file */
#include "misra_types.h"                         /* MISRA Types header file */
#include "defines.h"
#include "RSEDP_Slave_Address_Defines.h"        /* Slave address of I2C Peripherals */

#include "RSEDP_CNTRL_I2C.h"                    /* Control I2C Driver */




/* Function Prototypes */
sint32_t RSEDP_AM_Init_MAX1x3x(uint8_t I2C_addr) ;
sint32_t RSEDP_AM_MAX103x_ReadChannel(uint8_t I2C_addr, uint8_t *uiResult, uint8_t uiChannel) ;
sint32_t RSEDP_AM_MAX113x_ReadChannel(uint8_t I2C_addr, uint16_t *uiResult, uint8_t uiChannel) ;






/* Reset and initialise MAX1x3x ADC */
sint32_t RSEDP_AM_Init_MAX1x3x(uint8_t I2C_addr)
    {
        sint32_t Ack_Status = 0;
        sint8_t uiSetup_byte = 0;
        sint8_t uiConfig_byte = 0;
        sint8_t uiMessage[3] = {0,0,0};
    
    
        /* Create Setup Byte for REST */
           uiSetup_byte = MAX1x3x_SETUP_RST | MAX1x3x_SETUP_REG;
    
        /* Send Reset Command */
        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(I2C_addr, &uiSetup_byte, 1) ;
        
        /* Create Setup Byte */
        /* Internal reference always on and ADC11=analogue input and not Vref, Internal Clock      */
        uiSetup_byte = MAX1x3x_SETUP_REG | MAX1x3x_SETUP_SEL_INT_Ref_AN11_AlwaysOn | MAX1x3x_SETUP_IntCLK | MAX1x3x_SETUP_UniPol | MAX1x3x_SETUP_NO_RST;
    
        /* Create CONFIG Byte */
        /* Convert single ended unipolar, channel 0 initially */
        uiConfig_byte = MAX1x3x_CONFIG_REG | MAX1x3x_CONFIG_SingleEnded | MAX1x3x_CONFIG_ConvCh0 ; 
    
        uiMessage[0] = uiSetup_byte ;
        uiMessage[1] = uiConfig_byte ;
    
        /* Send */
        if (Ack_Status == ACK)
            {
                Ack_Status = CNTRL_I2C_Master_Mode_Transmit(I2C_addr, uiMessage, 2) ;
            }
        return Ack_Status;
    }




/* Reads a single channel MAX103x I2C ADC passed as a parameter */
/* returns a pointer to the 8-bit result */
sint32_t RSEDP_AM_MAX103x_ReadChannel(uint8_t I2C_addr, uint8_t *uiResult, uint8_t uiChannel)
    {
        sint32_t Ack_Status = 0;
        sint8_t uiConfig_byte = 0;
        sint8_t uiResult_value = 0;
        uint8_t uiCorrected_Channel = 0;
        

        /* Set which channel to convert */
        /* The pin out for MAX1038 is different from MAX1138 */
        /* The channel numbers 0-7 are reversed on the MAX1038. The PCB has been laid out for the MAX1138 */
        uiCorrected_Channel = uiChannel;
        if (uiChannel < 8) 
            {
                uiCorrected_Channel = (7 - uiChannel);        
            }
        uiConfig_byte = MAX1x3x_CONFIG_REG | MAX1x3x_CONFIG_SingleEnded | (uint8_t)(uiCorrected_Channel << 1) | MAX1x3x_CONFIG_SingleChannel ; 
        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(I2C_addr, &uiConfig_byte, 1) ;

        /* Read Result */
        if (Ack_Status == ACK)
            {
                Ack_Status = CNTRL_I2C_Master_Mode_Receive(I2C_addr, &uiResult_value , 1) ;
            }
        
        
        /* Return result to caller */
        *uiResult = uiResult_value ;
        return Ack_Status;
    }




/* Reads a single channel MAX113x I2C ADC passed as a parameter */
/* returns a pointer to the 16-bit result */
sint32_t RSEDP_AM_MAX113x_ReadChannel(uint8_t I2C_addr, uint16_t *uiResult, uint8_t uiChannel)
    {
        sint32_t Ack_Status = 0;
        sint8_t uiConfig_byte = 0;

        union BWL { sint8_t uiBytes[4] ; uint16_t uiWords[2] ; uint32_t uiLong ; } ;
        union BWL sResult ;
    

        /* Set which channel to convert */
        uiConfig_byte = MAX1x3x_CONFIG_REG | MAX1x3x_CONFIG_SingleEnded | (uint8_t)(uiChannel << 1) | MAX1x3x_CONFIG_SingleChannel ; 
        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(I2C_addr, &uiConfig_byte, 1) ;

        /* Read Result */
        if (Ack_Status == ACK)
            {
                Ack_Status = CNTRL_I2C_Master_Mode_Receive(I2C_addr, &sResult.uiBytes[0] , 2) ;
            }
    
        /* Return result to caller */
        *uiResult = sResult.uiWords[0] ;
        return Ack_Status;
    }

