/* Source Driver File for the AD5263 Digital Potentiometer */
/* ******************************************************* */

/* Version 1.00 */
/* Last Ammend Date: 23/6/09 */


#define _AD5263_



/* Include Files Here */
#include "mbed.h"                                /* mbed header file */
#include "misra_types.h"                         /* MISRA Types header file */
#include "defines.h"
#include "RSEDP_Slave_Address_Defines.h"        /* Slave address of I2C Peripherals */

#include "RSEDP_CNTRL_I2C.h"                    /* Control I2C Driver */







/* Function Prototypes */
sint32_t RSEDP_AM_Init_AD5263(uint8_t I2C_addr) ;
sint32_t RSEDP_AM_Set_AD5263_resistance(uint8_t I2C_addr, uint8_t uiChannel, uint16_t uiResistance_Ohms) ;


/* Global Variables */
uint16_t AD5263_default_resistances[AD5263_No_Of_Channels] = { AD5263_RDAC1_Default_Resistance, AD5263_RDAC2_Default_Resistance, AD5263_RDAC3_Default_Resistance, AD5263_RDAC4_Default_Resistance } ;






/* Reset and initialise AD5623 RDAC */
sint32_t RSEDP_AM_Init_AD5263(uint8_t I2C_addr)
    {
        sint8_t uiSetup_byte = 0;
        uint8_t uiChannel_no = 0;
        sint32_t Ack_Status = 0;

        for(uiChannel_no = 0; uiChannel_no < AD5263_No_Of_Channels ; uiChannel_no++)
            {
                /* Create Setup Byte */
                /* Set channel 0 to midscale */
                   uiSetup_byte = AD5263_RDAC_Midscale_Reset | (uiChannel_no << 5) ;

                /* Send Command */
                Ack_Status = CNTRL_I2C_Master_Mode_Transmit(I2C_addr, &uiSetup_byte, 1) ;
               }
        return Ack_Status; 
    }



/* Convert a raw value in Ohms to a resistance */
sint32_t RSEDP_AM_Set_AD5263_resistance(uint8_t I2C_addr, uint8_t uiChannel, uint16_t uiResistance_Ohms)
    {
        sint32_t Ack_Status = 0;
        uint16_t uiScaled_resistance = 0;
        sint8_t uiMessage[3] = {0,0,0};

        /* Set channel */
          uiMessage[0] = ((uiChannel-1) << 5) ;

        /* Convert resistance in Ohms to a number of steps */
        uiScaled_resistance = ((uint32_t)uiResistance_Ohms * AD5263_Resolution)/AD5263_Max_Resistance ;
          uiMessage[1] = uiScaled_resistance ;
    
        /* Send command */
        Ack_Status = CNTRL_I2C_Master_Mode_Transmit(I2C_addr, uiMessage, 2) ;
        return Ack_Status;
    }


