/* Slave Address Header File */



#define MICROCHIP_MOTOR_DRIVER_BASE 0x40
    /* Microchip Twin Motor Drive Module RD-EDP-AM-MC2 */
	/* 0x40 - 7 bit */
	/* Range is 0x40 - 0x47 as there may be 4 modules per base board */
	/* This device is used to define the Microchip dsPIC33FJ128MC804 I2C Slave Address */
	/* Upto 6 dsPIC devices can be populated (3 modules) on the motor drive board */
	/* Therefore the 7 bit address range is 0x40 - 0x45 */
	/* The link options on the module provide additional Slave address information */

/* Defines the range of the dsPIC Slave Address's. The base address is configured above */
/* As we can have up to 8 dsPICs in the system, we need to specify the range of address's */
#define DSPIC_SLAVE_ADDRESS_MIN (MICROCHIP_MOTOR_DRIVER_BASE)					/* min is 7 bit base of 112 */
#define DSPIC_SLAVE_ADDRESS_MAX ((MICROCHIP_MOTOR_DRIVER_BASE) +7)			    /* max is 7 bit base of 112 plus the DIP switch/solder bridge settings on the PCB 0 - 7 */


#define PCA9675_BASE_BOARD 0x20                       // 0x20 - 7 bit
    /* This device is on the base board and is a serial I/O latch connected to the DIP Switch */


#define M24C32_BASE_BOARD 0x51                      // 0x51 - 7 bit
    /* This device is a serial EEPROM device which is connected to the base board */
    /* The actual slave address also has three low order bits to be added */
    /* These bits are b1,b2,b3 within the byte */
    /* These bits are derived from the external A0,A1 and A2 pins on the device */
    /* Therefore the slave address's are 0xa0, 0xa2, 0xa4,0xa6,0xa8,0xaa, 0xac,0xae */


#define PCF8583_COMMS_MODULE 0x50                // 0x50 - 7 bit                
/* The actual slave address also has three low order bits to be added */
/* These bits are b1,b2,b3 within the byte*/
/* These bits are derived from the external A0,A1 and A2 pins on the device */
/* Therefore the slave address's are 0xa0, 0xa2, 0xa4,0xa6,0xa8,0xaa, 0xac,0xae */



#define PCA9555_DIGITAL_IO_OUT 0x23                 // 0x23 - 7 bit
    /* The actual slave address also has three low order bits to be added */
    /* These bits are a0,a1,a2 within the byte*/
    /* These bits are derived from the external A0,A1 and A2 pins on the device */
    /* Therefore the 7 bit slave address range is 0x20 to 0x27 */
                                        

#define PCA9555_DIGITAL_IO_IN 0x22                // 0x22 - 7 bit    
    /* This is the hardware configured 0x22 7 bit Slave Address of this perihperal */


#define MAX1X3X_ANALOGUE_ADC 0x65                // 0x65    - 7 bit
    /* This is the slave address of the MAX1038 on the Analogue Module PCB */


#define AD5263_ANALOGUE_DIGITAL_POT 0x2c        // 0x2c - 7 bit
    /* This is the slave address of the digtial Potentiometer, AD5263 on the anlogue module */


