/* All the header files are called by this one header */
/* ************************************************** */

/* This is the top most parent header file which includes all the other header files associated with the RS-EDP platform */

#include "misra_types.h"					/* Standard MISRA type defines */
#include "defines.h"						/* General Defines used by the modules */
#include "RSEDP_Slave_Address_Defines.h"	/* If you change the hardware I2C address of any of the devices on the modules then you must reflect the new I2C address in this header file */


#include "RSEDP_Mbed_Module.h"				/* all the low level peripheral drivers on te mbed module - IO ports, UART, SPI, I2C etc */
#include "RSEDP_Base_Board.h"				/* All the base board functions - EEPROM and erial latch */
#include "RSEDP_Comms_Module.h"				/* Functions to control the real time clock */
#include "RSEDP_Digital_IO_Module.h"		/* All the functions to control the serial input and output latches */
#include "RSEDP_Analogue_Module.h"			/* Functions to control digital pot and serial ADC */
#include "RSEDP_MC1.h"						/* Function relating to the Brushed DC Motor Drive module MC1 */

#include "RSEDP_Test.h"						/* Test function to exercise all of the above */
