/* Header File For Real time clock IC */
/* ********************************** */

                                        
                                        
/* Function Prototypes Here */
extern sint32_t RSEDP_COM_setup_PCF8583(uint8_t Slave_Address, uint8_t mode);                                                /* Setup the device */
extern sint32_t RSEDP_COM_PCF8583_Read_Status_Register(uint8_t Slave_Address, uint8_t *status_register);                        /* Read the status register of the device */
extern sint32_t RSEDP_COM_PCF8583_Write_Status_Register(uint8_t Slave_Address, uint8_t payload);                             /* Status register write */

/* RTC Function */
extern sint32_t RSEDP_COM_PCF8583_Write_RTC(uint8_t Slave_Address, uint8_t *RTC_Array);                                        /* Write raw data to the RTC device */
extern sint32_t RSEDP_COM_PCF8583_Read_RTC(uint8_t Slave_Address, uint8_t *RTC_Array);                                        /* Read raw data from the real time clock */
extern sint32_t RSEDP_COM_PCF8583_Set_Clock(uint8_t Slave_Address, uint8_t hours, uint8_t minutes, uint8_t seconds,uint8_t F24hour_flag, uint8_t AMPM_flag);    /* Set the clock only */
extern sint32_t RSEDP_COM_PCF8583_Set_Date(uint8_t Slave_Address, uint8_t dow, uint8_t day,uint8_t month, uint16_t year);    /* Set the date only */
extern sint32_t RSEDP_COM_PCF8583_Read_Clock(uint8_t Slave_Address, uint8_t *Time_Array);                                    /* Read the time component only */
extern sint32_t RSEDP_COM_PCF8583_Read_Date(uint8_t Slave_Address, uint8_t *Date_Array);                                        /* Read the date component only */
extern sint32_t RSEDP_COM_PCF8583_Read_Clock_And_Date(uint8_t Slave_Address, uint8_t *Time_Array,uint8_t *Date_Array);         /* Read time and date */ 
extern sint32_t RSEDP_COM_PCF8583_Start_Clock(uint8_t Slave_Address);                                                        /* Start the clock counting */
extern sint32_t RSEDP_COM_PCF8583_Stop_Clock(uint8_t Slave_Address);                                                            /* Stop the clock */

/* Battery Maintained SRAM functions */
extern sint32_t RSEDP_COM_PCF8583_Read_SRAM(uint8_t Slave_Address, uint8_t *read_data,uint8_t address);                        /* Read data from the battery maintained SRAM */
extern sint32_t RSEDP_COM_PCF8583_Write_SRAM(uint8_t Slave_Address, uint8_t payload,uint8_t address);                         /* Write data to the battery maintained SRAM */

/* Print functions for time and date */
extern void RSEDP_COM_Print_Time(uint8_t *Time_Array);
extern void RSEDP_COM_Print_Date(uint8_t *Date_Array);
extern void RSEDP_COM_Print_Time_Date_Year(uint8_t *RTC_Array);

