/* Header File for the Serial Input Latch PCA9675 Device on the RS-EDP Base Board */
/* ****************************************************************************** */


extern sint32_t RSEDP_BB_setup_PCA9675(uint8_t Slave_Address);                                                    
/* Setup and configure the serial I/O latch for input reading mode */
/* This function is called to reset the device to configure the I/O to input mode */
/* The only parameter to be passed is the Slave Address of the device on the board. */


extern sint32_t RSEDP_BB_PCA9675_reset(uint8_t Slave_Address);                                                    
/* Reset the device using a general call */
/* This function uses the general call address feature to reset the device to power on status */



extern sint32_t RSEDP_BB_PCA9675_write_data(uint8_t Slave_Address, uint8_t port0_payload, uint8_t port1_payload);            
/* Write two bytes to the device */
/* This function writes two bytes, the first to the Port0 and second to Port1 */


extern sint32_t RSEDP_BB_PCA9675_read_data(uint8_t Slave_Address, uint8_t *read_port0, uint8_t *read_port1);    
/* Read two bytes from the device */

extern sint32_t RS_EDP_BB_Read_DIP_Switch(uint8_t Switch_Number, uint8_t *Switch_Status);                                                    
/* Read the switch position - either on or off */
/* Call this function with a value 1 to 8 for the actual on/off status of the switch */
/* the retrun status is 'DIP_SWITCH_ON' or 'DIP_SWITCH_OFF' */
/* you can call this function with 'ALL_DIP_SWITCHES' and the value return is the 8 bit number read by the latch */
