/*
Title:          7 Segment Checker
Author:         David Ross 
Date:           May 27th, 2016
Description:    This program will individually light up segments
                a, b, c, ... , h (dot) continually with a 0.5 second
                delay between each segment displayed
*/

#include "mbed.h"

// Declaration Section for seven_segs

BusOut seven_segs (D2, D3, D4, D6, D7, D9, D10, D11);   // MSB=D11, LSB=D2
int main(void)
{
    
    unsigned char value=0x80;               // set value for CC Display
    unsigned char temp;                     // temp value for troubleshooting
    for(;;)                                 // loop forever
    {
        temp= ~value;                       // invert value for CA display
        seven_segs= temp ;                  // send value to 7 segments
        wait_ms(500);                       // wait 0.5 seconds
        value=value >> 1;                   // shift  to select next segment
        if(value < 1)                       // if value is 0
        {
            value=1;                        // then reset to 1
            do                              // reverses pattern
            {
                temp= ~value;               // invert for CA display
                seven_segs= temp;           // send value to 7 sements
                wait_ms(500);               // wait 0.5 seconds
                value = value <<1;          // shift to select next segment
            }while (value<0x80);            // as long as < 0x80 
            value=0x80;                     // then reset value to 0x80
        }
        
    }       
}