/*
Title:      Program to send DATA to  Sparkfun Stream
Author:     David Elmo Ross, 123-456-789, AED_701AA
Date:       Oct 5th, 2016
Desription: This program simulates Celsius and Fahrenheit values. This can
            be changed to get these values from a Temperature sensor.
            This program will set up the necessary parameters to communicate
            through the Ethernet Port on the FRDM-K64 that will then connect
            to the SPARKFUN Server. The data provided by this program is formatted
            to fit a STREAM on the Sparkfun Server that was set up before time with
            Fahrenheit and Celsius.
            When data is sent to the stream, it will include a PUBLIC and PRIVATE
            key or it will be rejected. These keys are given to the user through 
            the site    data.sparkfun.com  
            The key values you receive must replace the ones in this program.
            
*/

#include "mbed.h"
#include "EthernetInterface.h"

char* Public_Key = "PublicKeyGoesHere";             // Public Key is used to access data that has been sent
char* Private_Key = "PrivateKeyGoesHere";           // Private Key is sent with Public Key with every data xfer
char* ServerIP = "data.sparkfun.com";               // Server IP is  data.sparkfun.com

EthernetInterface ethernet;                         // define ethernet to be of type EthernetInterface

int main()
{
    int counter;                                    // used as a counter to send a fixed number of values
    putchar(0x1b);                                  // clears the PC screen
    printf("[2J");

    printf("Start\r\n");                            // send START message to PC screen
    float fahrenheit;                               // set up fahrenhiet as a float
    float celsius=5.0;                              // set celcius to 5.0
   
    while(1)
    {          
        int ret = ethernet.init();                  // ret gets result of ethernet.init()
                                                    // 0 means that initialization was successful
        if (!ret)                                   // if initialization WAS successful
        {                                           // output the MAC address
            printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();               // ret gets result of ethernet.connect()
            if (!ret)                               // 0 means that connection was successufl
            {                                       // if connection print out IP MASK and GATEWAY
                printf("IP: %s, MASK: %s, GW: %s\r\n",
                ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            } 
            else                                    // if no connection then Print error and terminate 
            {
                printf("Error ethernet.connect() - ret = %d\r\n", ret);
                exit(0);
            }
        } 
        else                                        // if ethernet would NOT initialize, print error and terminate
        {
            printf("Error ethernet.init() - ret = %d\r\n", ret);
            exit(0);
        }  
        TCPSocketConnection sock;                   // define sock to be of type TCPSocketConnection
  
        int ret_t;   
        char http_cmd[256];                         // set up 256 byte buffer for http commands sent to Sparkfun
            for(counter=1;counter<=10;++counter)
            {
            sock.connect(ServerIP, 80);             // connect to SPARFUN on PORT 80 and print server IP
            printf("Server IP: %s", ServerIP);      
            if(sock.is_connected())                 // if connection is made say Socket Connected
                printf("Socket Connected\n\r");
            else
            {                                       // else print Socket NOT connected
                printf("Socket NoT Connected\n\r");
                printf("\r\n Program has halted");
                exit(0);
             }     
            // format string http_cmd   
            fahrenheit= ((9.0/5.0)*celsius + 32); 
            sprintf(http_cmd,"GET /input/%s?private_key=%s&fahrenheit=%0.1f&celsius=%.1f HTTP/1.0\n\n",Public_Key,Private_Key,fahrenheit, celsius);
            // send formatted string
            sock.send_all(http_cmd, sizeof(http_cmd)-1);
            printf("\tcelsius =%.1f\tfahrenheit=%.1f\r\n",celsius,fahrenheit);
        
            sock.close();                           // close the socket
 //           station++;
            celsius+=1.1;
            wait(5);
            }
        printf("\r\n\r\nProgram has halted - all data sent.");
        exit(0);
        }
    
    
    }
