/*
    Title:  Program to keep track of time on 4 digit display
    Description: This program will keep keep track of time
                 with initial hours minutes seconds set by
                 Global variables. The time is given in military format
*/
#include "mbed.h"                       // include mbed library
#include "DigitDisplay.h"               // include digit display library
DigitalOut myled(LED1);                 // define myled to be internal RED led
DigitDisplay display(D2,D3);            // connect digit display to D1 connector
Ticker tick;                            // set up periodic interrupt called tick

// Global Variables                     // initialize hour minute and second
uint8_t hour   = 14;                    // same as unsigned char hour
uint8_t minute = 44;                    // same as unsigned char minute
uint8_t second = 0;                     // same as unsigned char second

void beat()                             // periodic interrupt code
{
    static uint8_t colon = 0;           // initialize colon to off  
    display.setColon(colon);            // update colon on display
    if (colon) 
    {                                   // if colon on add 1 to second
       second++;
       if (second >= 60) 
       {                                // if > or = 60 sec reset to 0
         second = 0;
         minute++;                      // add 1 to minute counter
         if (minute >= 60) 
            {                           // if > or = 60 then reset to 0
               minute = 0;
               hour++;                  // add 1 to hour counter
               if (hour >= 24)          // if > or = 24 then reset to 0
                   hour = 0;
                                        // update hour on left 2 displays
                display.write(0, hour / 10);
                display.write(1, hour % 10);
            }                           // update minute on right 2 displays
          display.write(2, minute / 10);
          display.write(3, minute % 10);
       }
    }
    colon = 1 - colon;                  // invert colon value
}

int main() 
{
    display.write(0, hour / 10);        // put left digit of hour on left disp
    display.write(1, hour % 10);        // put right digit of hour on next disp
    display.write(2, minute / 10);      // put left digit of min on next disp
    display.write(3, minute % 10);      // put right digit of min on next disp
    display.setColon(true);             // turn colon on 
    tick.attach(&beat, 0.5);            // beat() activates every 0.5 seconds
    while(1)                            // endless loop
    {  
        myled = 1;                      // turn off red led
        wait(0.5);                      // wait 0.5 seconds
        myled = 0;                      // turn on red led
        wait(0.5);                      // wait 0.5 seconds
    }
}
