#pragma once

#include <mbed.h>

class Pacer
{
    public:
    Pacer(int32_t pace_us)
      : pace_us(pace_us), last_time(0)
    {
        timer.start();
    }
    
    bool ready()
    {
        return (time() - last_time) >= pace_us;
    }
    
    // This should generally only be called when ready() is true.    
    void advance()
    {
        last_time += pace_us;
    }
    
    void clear()
    {
        last_time = time();   
    }
    
    bool pace()
    {
        if (ready())
        {
            clear();
            return true;   
        }
        else
        {
            return false;
        }
    }
    
    private:
    uint32_t time()
    {
        return (uint32_t)timer.read_us();  // Cast int32_t to uint32_t.
    }
    
    uint32_t pace_us;
    uint32_t last_time;
    Timer timer;
};