#pragma once

#include <mbed.h>

class TurnSensor
{
    // TODO: for production code, you would want a way to set the gyro offset

    public:

    void reset();
    void start();
    void update();
    
    int32_t getAngle()
    {
        return (int32_t)angleUnsigned;
    }
    
    uint32_t getAngleUnsigned()
    {
        return angleUnsigned;
    }
    
    int16_t getAngleDegrees()
    {
        return (((int32_t)angleUnsigned >> 16) * 360) >> 16;
    }
    
    int16_t getRate()
    {
        return rate;
    }
    
    private:

    Timer timer;
    uint32_t angleUnsigned;
    int16_t rate;
    uint16_t gyroLastUpdate;
};


// This constant represents a turn of 45 degrees.
const int32_t turnAngle45 = 0x20000000;

// This constant represents a turn of 90 degrees.
const int32_t turnAngle90 = turnAngle45 * 2;

// This constant represents a turn of approximately 1 degree.
const int32_t turnAngle1 = (turnAngle45 + 22) / 45;