#pragma once

#include "reckoner.h"
#include "line_tracker.h"
#include "logger.h"
#include "turn_sensor.h"

void loadCalibration();

void waitForSignalToStart();
void followLineFast();

void updateMotorsToFollowLineFast(int16_t drivingSpeed);
void updateMotorsToFollowLineSlow();

void __attribute__((noreturn)) loggerReportLoop();

void updateReckonerFromEncoders();
void updateReckoner(TurnSensor &);
void setLeds(bool v1, bool v2, bool v3, bool v4);
float determinant();
float dotProduct();
float magnitude();
void loggerService();
void waitForSignalToStart();
void followLineSmart();

extern Reckoner reckoner;
extern LineTracker lineTracker;
extern Logger logger;
extern TurnSensor turnSensor;