#include <mbed.h>
#include "buttons.h"
#include "GeneralDebouncer.h"

#define BUTTON_DEBOUNCE_TIME 20000

DigitalIn button1(p13);

GeneralDebouncer button1Debouncer(5000);

void buttonsInit()
{
    button1.mode(PullUp);
}

bool button1IsPressed()
{
    return button1.read() == 0;
}

void button1Montior()
{
    button1Debouncer.update(button1IsPressed());
}

bool button1DefinitelyInState(bool state)
{
    button1Montior();
    return button1Debouncer.getState() == state &&
      button1Debouncer.getTimeInCurrentStateMicroseconds() > BUTTON_DEBOUNCE_TIME;
}

bool button1DefinitelyPressed()
{
    return button1DefinitelyInState(true);
}

bool button1DefinitelyReleased()
{
    return button1DefinitelyInState(false);
}


