#pragma once

class Reckoner
{
    public:
    
    Reckoner();
    
    // Together, cos and sin form a vector with a magnitude close to 2^30 that indicates
    // the current position of the robot.
    // cos corresponds to the x component of the orientation vector.
    // sin corresponds to the y component of the orientation vector.
    int32_t cosv, sinv;
    
    // Together, x and y are a vector that points from the starting point to the
    // robot's current position.
    // The untis are Df / (1<<14), where Df is the distance the robot moves forward
    // or backwards due to a single encoder tick.
    int32_t x, y;

    void reset();

    void handleTickLeftForward();
    void handleTickLeftBackward();
    void handleTickRightForward();
    void handleTickRightBackward();
    void handleForward();
    void handleBackward();
    void handleRight();
    void handleLeft();
    void handleTurnRadians(int32_t radians);
    void setTurnAngle(int32_t angle);
};
