#pragma once

#include "logger.h"
#include "pc_serial.h"

Logger::Logger()
{
    entryIndex = 0;   
}

bool Logger::isFull()
{
    return entryIndex >= LOGGER_SIZE;
}

void Logger::log(struct LogEntry * newEntry)
{
    if (isFull())
    {
        return;   
    }
    
    LogEntry * entry = &entries[entryIndex];
    entryIndex++;
    *entry = *newEntry;    
}

void Logger::dump()
{
    pc.printf("Log dump start\r\n");
    for(int32_t i = 0; i < entryIndex; i++)
    {
        LogEntry * entry = &entries[i];
        pc.printf("%d,%d,%d\r\n", entry->turnAngle, entry->x, entry->y);
    }
    pc.printf("Log dump end\r\n");
}