#pragma once

#include "line_sensors.h"

class LineTracker
{
    public:
    LineTracker();
    
    void updateCalibration();
    
    void read();    
    bool getLineVisible();
    uint16_t getLinePosition();
    
    uint16_t rawValues[LINE_SENSOR_COUNT];
    uint16_t calibratedValues[LINE_SENSOR_COUNT];
    uint16_t calibratedMaximum[LINE_SENSOR_COUNT];
    uint16_t calibratedMinimum[LINE_SENSOR_COUNT];
    
    private:
    void readRawValues();
    void updateCalibratedValues();
    void updateLineStatus();

    uint8_t calibrationState;
    uint16_t recentValuesMax[LINE_SENSOR_COUNT];
    uint16_t recentValuesMin[LINE_SENSOR_COUNT];
    
    bool lineVisible;
    uint16_t linePosition;
};
