#include "encoders.h"

const PinName encoderPinLeftA = p6,   // Gray wire
              encoderPinLeftB = p7,   // White wire
              encoderPinRightA = p30,  // White wire
              encoderPinRightB = p29;  // Gray wire

PololuEncoderBuffer encoderBuffer;
PololuEncoder encoderLeft(encoderPinLeftA, encoderPinLeftB, &encoderBuffer, ENCODER_LEFT);
PololuEncoder encoderRight(encoderPinRightA, encoderPinRightB, &encoderBuffer, ENCODER_RIGHT);

void encodersInit()
{
    DigitalIn(encoderPinLeftA).mode(PullNone);
    DigitalIn(encoderPinLeftB).mode(PullNone);
    DigitalIn(encoderPinRightA).mode(PullNone);
    DigitalIn(encoderPinRightB).mode(PullNone);
    wait_us(50);
    encoderLeft.init();
    encoderRight.init();   
}