#pragma once

#define RECKONER_LOG_UNIT 14

class Reckoner
{
public:
    
    Reckoner();
    
    // Together, cos and sin form a vector with a magnitude close to 2^14 that
    // indicate the current direction the robot is facint.
    int32_t cosv, sinv;
    
    // Together, x and y are a vector that points from the starting point to the
    // robot's current position, with units of Df / (1<<14), where Df is the
    // distance the robot moves due to a single encoder tick.
    int32_t x, y;

    void reset();
    void handleForward();
    void handleBackward();
    void setTurnAngle(int32_t angle);
};
