#pragma once

#include "reckoner.h"
#include "line_tracker.h"
#include "logger.h"
#include "turn_sensor.h"

void loadLineCalibration();
void doGyroCalibration();

void waitForSignalToStart();
void findLineAndCalibrate(); void findLine();  // two alternatives
void followLineToEnd();
void driveHomeAlmost();
void finalSettleIn();
void __attribute__((noreturn)) loggerReportLoop();

void updateMotorsToFollowLine();
void updateReckoner();
void setLeds(bool v1, bool v2, bool v3, bool v4);
float determinant();
float dotProduct();
float magnitude();
void loggerService();

extern Reckoner reckoner;
extern LineTracker lineTracker;
extern TurnSensor turnSensor;
extern Logger logger;
