#include "line_sensors.h"

DigitalInOut lineSensorsDigital[LINE_SENSOR_COUNT] = {
    DigitalInOut(p18), // white wire, left-most sensor
    DigitalInOut(p19), // orange wire, middle sensor
    DigitalInOut(p20), // brown wire, right-most sensor
};

void readSensors(uint16_t * values)
{
    for(uint8_t i = 0; i < LINE_SENSOR_COUNT; i++)
    {
        values[i] = 1000;
        lineSensorsDigital[i].mode(PullNone);
        lineSensorsDigital[i].output();
        lineSensorsDigital[i].write(1);
    }
    
    wait_us(10);
    
    Timer timer;
    timer.start();

    for(uint8_t i = 0; i < LINE_SENSOR_COUNT; i++)
    {
        lineSensorsDigital[i].input();
    }

    while(timer.read_us() < 1000)
    {
        for(uint8_t i = 0; i < LINE_SENSOR_COUNT; i++)
        {
            if (values[i] == 1000 && lineSensorsDigital[i].read() == 0)
            {
                values[i] = timer.read_us();   
            }
        }
    }
}
