#include "encoders.h"

const PinName encoderPinLeftA = p6,   // White wire
              encoderPinLeftB = p7,   // Yellow wire
              encoderPinRightA = p30,  // Yellow wire
              encoderPinRightB = p29;  // White wire

PololuEncoderBuffer encoderBuffer;
PololuEncoder encoderLeft(encoderPinLeftA, encoderPinLeftB, &encoderBuffer, ENCODER_LEFT);
PololuEncoder encoderRight(encoderPinRightA, encoderPinRightB, &encoderBuffer, ENCODER_RIGHT);

void encodersInit()
{
    DigitalIn(encoderPinLeftA).mode(PullNone);
    DigitalIn(encoderPinLeftB).mode(PullNone);
    DigitalIn(encoderPinRightA).mode(PullNone);
    DigitalIn(encoderPinRightB).mode(PullNone);
    wait_us(50);
    encoderLeft.init();
    encoderRight.init();   
}