#pragma once

// Returns 0 for success, non-zero for error.
int32_t l3gInit();
int32_t l3gReadReg(char reg);
int32_t l3gWriteReg(char reg, char value);
int32_t l3gZRead();
int32_t l3gZAvailable();

// Takes one reading and record it for the purposes of zero-rate calibrations.
// Returns the reading just in case you want it for something.
int32_t l3gCalibrate();

bool l3gCalibrateDone();

void l3gCalibrateReset();

int32_t l3gZReadCalibrated();
