#include "mbed.h"
#include "SDFileSystem.h"
//comment
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led1(LED1);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //i, o, clk, cs, const : on the card 3,7,5,2
Ticker logger;

void loggit() {
    time_t seconds = time(NULL);
    int mins = seconds/60;
    int hours = seconds/3600;
    int secs = seconds - (mins*60) - (hours * 3600);
    pc.printf("FORMATTED ");
    pc.printf("%04.4i:%02.2i:%02.2i \n\r", hours,mins,secs);

    char  strh[4];
    char  strm[2];
    char  strs[2];

    sprintf(strh, "%04.4i",hours);
    sprintf(strm, "%02.2i",mins);
    sprintf(strs, "%02.2i",secs);
    FILE *lp = fopen("/sd/log.csv", "a");
    pc.printf("Open");
    fprintf(lp,strh);
    fprintf(lp,":");
    fprintf(lp,strm);
    fprintf(lp,":");
    fprintf(lp,strs);
    fprintf(lp,",");
    fprintf(lp,"12 \r");
    fclose(lp);
    pc.printf("Closed");
}

int main() {

    set_time(1);

    logger.attach(&loggit, 2.0);


    while (1) {
        led1 = !led1;
        wait(1);

    }

}
