#include "mbed.h"

DigitalOut relay1(p24);
DigitalOut chargeLED(p30);
DigitalOut dumpLED(p29);
AnalogIn load1 (p16);


#define rRatio  6.6355
#define EMPTY  12.2000
#define UPPER_CHARGE_LIMIT  13.0

int justConnected = 0;

void flash(void) {
for (int i=0;i<5;i++)  { 
        dumpLED = 1;
        chargeLED = 1;
        wait(0.5);
        dumpLED = 0;
        chargeLED = 0;    
        wait(0.5);
  }
 
}

//chargeLED = RED
//dumpLED = Green

 void chargeOne() {
 
  justConnected = 0;

  //with latch
   relay1=1;    
   chargeLED=1;
   dumpLED = 0;
   
   while (1) {
    
     float voltage1 = load1*rRatio*3.3000;
   
     float delay = 0.2;  
     if (UPPER_CHARGE_LIMIT > voltage1) {
        delay=0.2+(UPPER_CHARGE_LIMIT - voltage1);
     }
     
     wait (delay);
     chargeLED=1;
     wait (0.25);
     chargeLED=0;

     // When the battery is charged to the limit, switch the relay off and return
     voltage1 = load1*rRatio*3.3000;
     if (voltage1 >= UPPER_CHARGE_LIMIT ) {
        flash();
        relay1=0;    
        chargeLED=0;
        return;
     }   
    
   } //loop

}

void init(void) {
 for (int i=0;i<10;i++)  { 
        dumpLED = 1;
        wait(0.5);
        dumpLED = 0;
        chargeLED = 1;
        wait(0.5);
        chargeLED = 0;     
  }
 for (int i=0;i<1;i++)  { 
        dumpLED = 1;
        chargeLED = 1;
        wait(0.5);
        dumpLED = 0;
        chargeLED = 0;    
        wait(0.5);
  }
  
  justConnected = 1;
 
}


void dump() {

 dumpLED = 1;
 wait(0.5);
 dumpLED = 0;
 
}

int main() {
    init();
    while(1) {
     wait(1);
     float voltage1 = load1*rRatio*3.3000;
     if ((voltage1 <= EMPTY) || ((justConnected == 1) && (voltage1 < UPPER_CHARGE_LIMIT))) {
        chargeOne();
     } else {
        dump();
     }    

    } 
}
