#include "mbed.h"
#include "hcsr04.h"
 
#define     MOT_A_IN_1      D3
#define     MOT_A_IN_2      D4
#define     MOT_A_PWM       D5
 
#define     MOT_B_IN_1      D9
#define     MOT_B_IN_2      D7
#define     MOT_B_PWM       D6
 
#define     STBY            D2
 
#define     ECHO            D11
#define     TRIGGER         D12
 
#define     LINE_LEFT       D14
#define     LINE_RIGHT      D15

#define EPSILON 50

PwmOut speedA(MOT_A_PWM);
PwmOut speedB(MOT_B_PWM);

//DigitalOut myled(LED1);
HCSR04 sonar(TRIGGER, ECHO);
Serial pc(USBTX, USBRX);

DigitalOut inA1(MOT_A_IN_1);
DigitalOut inA2(MOT_A_IN_2);
DigitalOut inB1(MOT_B_IN_1);
DigitalOut inB2(MOT_B_IN_2);

DigitalOut stby(STBY);

DigitalIn lineL(LINE_LEFT); // ?+
DigitalIn lineR(LINE_RIGHT); // ?

// ajout du 
 
void testMotors();
void testLineSensorsCustom();
void DetectThing();
 
int main() {
    //pc.baud(9600);
    //pc.printf("Hello World");
    //testMotors();
    //testLineSensorsCustom();
    //DetectThing();
    
    // Choix de la direction des moteurs, le robot avance.
    /*
    inA1 = 0;
    inA2 = 1;
    inB1 = 1;
    inB2 = 0;*/
    //DetectThing();
   
    // Choix de la vitesse de rotation des moteurs.
    //speedA = 0.3; // Moteur gauche
    //speedB = 0.3; // Moteur droit
    // vpourcentage par rapport à la vitesse max
   testMotors();
    // On active les moteurs
    //stby = 1;
    
}

void DetectThing()
{
    double dist;
    
    while (1)
    {
        sonar.start();
        dist = sonar.get_dist_cm();
        
        pc.printf("distance : %f\r\n", dist);
        //wait(0.2);
    }
 
}
 
void testMotors()
{
    // Choix de la direction des moteurs, le robot avance.
    inA1 = 1;
    inA2 = 0;
    inB1 = 1;
    inB2 = 0;
   
    // Choix de la vitesse de rotation des moteurs.
    speedA = 0.01; // Moteur gauche
    speedB = 0.01; // Moteur droit
    // vpourcentage par rapport à la vitesse max
   
    // On active les moteurs
    stby = 1;
    // si stby à 0 ? alors moteur en standby, enfaite stby est inv stby
   
    wait(0.5); // On avance pendant 1 secondes
   
    // On tourne pendant 1sec sur la gauche
    speedA = 0.5;
    wait(0.5);
   
    // On tourne pendant 1sec sur la droite
    speedA = 1;
    speedB = 0.5;
    wait(0.5);
   
    // On tourne sur place sur la gauche pendant 1sec
    speedB = 1;
    inA1 = 0;
    inA2 = 1;
    wait(0.5);
   
    // On tourne sur place sur la droite pendant 1sec
    inA1 = 1;
    inA2 = 0;
    inB1 = 0;
    inB2 = 1;
    wait(0.5);
   
    // On recule pendant 1sec;
    inA1 = 0;
    inA2 = 1;
    wait(0.5);
   
    // On avance de nouveau 1sec;
    inA1 = 1;
    inA2 = 0;
    inB1 = 1;
    inB2 = 0;
    wait(0.5);
   
    speedA=0;
    speedB=0;
}
 /*
void testLineSensorsCustom()
{
    float dist;
    
    inA1 = 1;
    inA2 = 0;
    inB1 = 1;
    inB2 = 0;
   
    stby = 1;
   
    speedA = 0;
    speedB = 0;
   
    while(dist > EPSILON/2)
    {
        sonar.start();
        dist = sonar.get_dist_cm();
        
        //pc.printf("distance : %f\r\n", dist);

        speedA = 1;
        speedB = .9;
        inA1 = 1;
        inA2 = 0;
        inB1 = 1;
        inB2 = 0;
    }

    
    while(dist < EPSILON/2)
    {
        sonar.start();
        dist = sonar.get_dist_cm();
        
        speedA = 0;
        speedB = 0;
        inA1 = inA2 = inB1 = inB2 = 1;
        
    }
}



    -> Choix direction
    -> Choix vitesse rotation moteur
    


        if (lineL <= .5)
            speedA = 0.9;
        else
            speedA = 0;
        if (lineR <= .5) // ??
            speedB = .7;
        else
            speedB = 0;
*/