/*
* Code for identifying address and temperature of DS1820 1-Wire Thermometers by Maxim
* Uses the DS1820 library written by Michael Hagberg and Fernando Caamaño, with some slight modifications
* Currently tested using DS18S20 1-Wire Thermometers in an array, parasite power yet to be tested
*/
#include "Temperature.h"
 
DS1820* probe[MAX_PROBES];
int devices_found = 0;
 
void temperature_init()
{
    DigitalOut isotherm_12V_pin(ISOTHERM_12V_PIN);
    isotherm_12V_pin = 1;
    int i;
    int address_byte_count;
    // Initialize the probe array to DS1820 objects
    for (i = 0; i < MAX_PROBES; i++)
        probe[i] = new DS1820(DATA_PIN, PARASITE_PIN);
    // Initialize global state variables
    probe[0]->search_ROM_setup();
    // Loop to find all devices on the data line
    while (probe[devices_found]->search_ROM() and devices_found<MAX_PROBES-1)
        devices_found++;
    // If maximum number of probes are found,
    // bump the counter to include the last array entry
    if (probe[devices_found]->ROM[0] != 0xFF)
        devices_found++;
 
    if (devices_found==0)
        printf("No devices found");
    else {
        printf("\n%d device(s) found!\r\n\n" ,devices_found);
        for (i=0; i<devices_found; i++) {
            printf("Device %d address is: \r\n", i+1);
            for(address_byte_count=0; address_byte_count<8; address_byte_count++) {
                printf("0x%02x", probe[i]->ROM[address_byte_count]);
                if(address_byte_count == 7) printf("\r\n\n");
                else printf(", ");
            }
        }
    }
}    
    