#include "mbed.h"

#ifndef EEPROM_I2C_H
#define EEPROM_I2C_H

#define I2C_DATA p9
#define I2C_CLOCK p10
#define ADDRESS_1 0xAF
#define ADDRESS_2 0xAE  // TODO check did both addresses work

/**
* Method for writing one byte to the EEPROM
*
* @param start_address the start address on the EEPROM to read from
* @param data_out data to send
*/
/* Dont think this will be used
void i2c_write(int start_address,char data_out);
*/
/**
* Method for reading from the EEPROM
*
* @param start_address the start address on the EEPROM to read from
*
*/
/*Dont think this will be used
char i2c_read(int start_address);
*/
/**
* Method for page writing to the EEPROM
*
* @param start_address the start address on the EEPROM to write to
* @param length the length of data_out
* @param data_out data to send
*
*/
void i2c_page_write(uint16_t start_address,int length, char data_out[] );

/**
* Method for page reading from the EEPROM
*
* @param start_address the start address on the EEPROM to read from
* @param length the length of data_in
* @param data_in data to read
*
*/
void i2c_page_read(uint16_t start_address,int length, char data_in[]);

#endif