#ifndef Data_Types_BMU_H
#define Data_Types_BMU_H

#include "CAN_Data.h"
#include "CAN_IDs.h"
#include "mbed.h"

#define NO_CMUS 3
#define NO_READINGS_PER_CMU 12
#define NO_TEMPERATURE_SENSORS 50

// CAN pins
#define CAN_WRITE_PIN p29
#define CAN_READ_PIN p30

// EEPROM addresses
#define START_WRITE_ADDRESS 0x0040
#define MAX_WRITE_ADDRESS 0x7FC0

// Error states
#define NONE = 0x00000000
#define CELL_OVER_VOLTAGE 0x00000001
#define CELL_UNDER_VOLTAGE 0x00000002
#define CELL_OVER_TEMPERATURE 0x00000004
#define MEASUREMENT_UNTRUSTED 0x00000008
#define CMU_COMMUNICATION_TIMEOUT 0x00000010
#define VEHICLE_COMMUNICATIONS_TIMEOUT 0x00000020
#define BMU_SETUP_MODE 0x00000040
#define CMU_CAN_POWER_STATUS 0x00000080
#define PACK_ISOLATION_TEST_FAILURE 0x00000100
#define SOC_MEASUREMENT_NOT_VALID = 0x00000200
#define CAN_12V_LOW = 0x00000400
#define CONTACTOR_NOT_ENGAGED = 0x00000800
#define CMU_EXTRA_CELL = 0x00001000

// Max values
#define MAX_CELL_VOLTAGE 1
#define MIN_CELL_VOLTAGE 1
#define MAX_CELL_TEMPERATURE 1

//CAN Buffer
#define CAN_BUFFER_SIZE 255 //Setting this to be quite large, should be equal to max # of ids expected to recieve

// Delay
#define LOOP_DELAY_S 0.1 // TODO is this delay the correct length?

struct individual_temperature{
    // Structure that will store a temperature value and also an ID 
    char ROMID[8]; //ROM array for temperature sensor, subset of it is useful as ID
    //ROMID 1-6 are the useful values for this case, ignore the rest
    float measurement;
};

struct CMU_voltage{
    // Structure that contains voltage information suitable for CAN bus
    uint8_t ID; // CMU serial number
    uint8_t CMU_number; // Number CMU's from 0-(N-1) (N is number of CMU's) it will aid CAN communications the ID and CMU number may be the same not sure yet
    
    //to be removed
    uint16_t first_cell_voltages[4]; // Split the cell voltages up easier to send over CAN
    uint16_t last_cell_voltages[4];
    
    //this now
    uint16_t voltages[NO_READINGS_PER_CMU]; 
};

struct pack_voltage_extremes{
    // structure useful for CAN ID 0x6F8
    uint16_t voltage; // maximum or minimum voltage
    uint8_t CMU_number; // CMU number of extreme voltage
    uint8_t cell_number; // cell number of extreme voltage
};

struct pack_temperature_extremes{
    uint16_t temperature; // maxiumum or minimum temperature
    uint8_t CMU_number; // CMU number of extreme voltage
};

struct BMU_data{
    // Data for the CAN bus see Tritium Communications Protocol
    // Cell voltage
    CMU_voltage cell_voltages[NO_CMUS]; // Store all voltage measurements in here
    pack_voltage_extremes max_cell_voltage;
    pack_voltage_extremes min_cell_voltage;
    uint32_t battery_voltage; // 5.9 Tritium data sheet
    uint32_t battery_current;
    
    // SOC 
    float SOC;
    float percentage_SOC;
    
    // Cell Temperature
    individual_temperature temperature_measurements[NO_TEMPERATURE_SENSORS]; // Store all of the temperature measurements in here
    pack_temperature_extremes max_cell_temp;
    pack_temperature_extremes min_cell_temp;
};


// @TODO are both the battery status and extended status used or just one of them
enum BMU_CAN_flags{
    // Think this is used for legacy software
};

#endif