#include "CAN_Data.h"
#include "CAN_IDs.h"
#include "Data_Types_BMU.h"

#ifndef CANParserBMU_H
#define CANParserBMU_H

//@TODO Move these definitions elsewhere ideally into CAN_IDS.h
#define BATTERY_SOC_BASE_ID 0xF5
#define MAX_MIN_VOLTAGE 0xF8
#define BLANK_DATA 0x00
#define MAX_MIN_TEMPERATURE 0xF9
#define BATTERY_PACK_STATUS_ID 0xFA

//@TODO add some comments
CANMessage createTemperatureTelemetry(uint8_t offset, char * ROMID, float Temperature);

individual_temperature decodeTemperatureTelemetry(CANMessage msg);

CANMessage createVoltageTelemetry(int ID, uint16_t voltage[]);

CANMessage createPackSOC(float SOC, float percentageCharge);

CANMessage createPackBalanceSOC(float SOC, float percentageCharge);

CANMessage createCellVoltageMAXMIN(pack_voltage_extremes max_voltage, pack_voltage_extremes min_voltage);

CANMessage createCellTemperatureMAXMIN(pack_temperature_extremes min_temperature, pack_temperature_extremes max_temperature);

CANMessage createBatteryVI(uint32_t batteryVoltage,uint32_t batteryCurrent);

CANMessage createBatteryPackStatus(uint16_t voltageThreshold[], uint8_t statusFlag,uint8_t BMS_CMU_Count,uint16_t BMS_Firmware_Build);

CANMessage createExtendedBatteryPackStatus(uint32_t status);


union float2byte {
    float f;
    char b[sizeof(float)];
};

#endif