#include "mbed.h"
#define INITCMD 0xFF

//Definiendo los puertos 
AnalogIn In_Sagua( A0 );

InterruptIn EncoMot ( PB_8 );

PwmOut Mot_As( PB_4 );
PwmOut BUZZ( PB_3 );

Timer t1 ;

Ticker tout0;
Ticker tout1;

DigitalOut Llenado( PA_3 );
DigitalOut Sacado( PA_6 );
DigitalOut Lemer( PA_7 );
DigitalOut led(LED1);
Serial bluetooth(D10, D2);
Serial pc ( USBTX, USBRX );
//Definiendo las variables Globales

volatile uint32_t L_Agua; 
float Pwm_Control;
char Read_Uart;
int nvueltas, nvueltas_n;
int Rpm;
volatile int Exit = 0 ;
volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Used for debouncing
Timeout button1_timeout; // Used for debouncing

//Definiendo las funciones

//void Rx_interrupt();
void Leer_Sagua();
void leer_datos();
void Funciones_Mezcladora(char _Funcion);

//Definidndo funciones de interrubluetoothion Encoder
// Habilita el botón cuando termina el rebote.
void button1_enabled_cb(void)
{
    button1_enabled = true;
}

// Botón presionado ISR evento presionado
void button1_onpressed_cb(void)
{
    if (button1_enabled) { // Disabled while the button is bouncing
        button1_enabled = false;
        button1_pressed = true; // To be read by the main loop
        button1_timeout.attach(callback(button1_enabled_cb), 0.1); // Debounce time 300 ms
    }
    
}
int main() {
    
    bluetooth.baud(9600) ;
    pc.baud ( 115200 );
    //printf(" Leyendo sensor de agua \n");
    
    nvueltas = 0;
    
    EncoMot.rise( callback( button1_onpressed_cb ) );
    tout0.attach( &Leer_Sagua, 1 );
    
    while(1) {
        
        if (button1_pressed) { //Establecer cuando se presiona el botón
            button1_pressed = false;
            nvueltas++;
            led = !led;
            //pc.printf("%d",nvueltas);
        }
        
        if( t1.read_ms()> 1000 ){

            nvueltas_n = nvueltas;
            nvueltas = 0;
            t1.reset();
            Rpm = ( ( nvueltas_n * 60) / ( 0.1 * 20 ) );
            pc.printf ( " Vueltas=  %d     Rpm=   %d      \n", nvueltas_n, Rpm );
//          pc.putc( nvueltas_n );
//          pc.putc( Rpm );
            Mot_As =  Mot_As+0.01f;
            
            int Oka;
            if(pc.readable()){Oka=pc.getc();}
            printf ( " %d \n ", Oka);
            if( Rpm > Oka*1.2 ){
                printf ( " Entro \n ");
                Mot_As = Mot_As - 0.02f ;
            }
        }   
        
        leer_datos();
        Funciones_Mezcladora(Read_Uart);
    }
}

////////////////////////////////////////////////////////////////////////////////
//                       Declaracion de funciones                             //
////////////////////////////////////////////////////////////////////////////////
void leer_datos(){
        
    if(bluetooth.readable()){
        Read_Uart = bluetooth.getc();
    }
}
////////////////////////////////////////////////////////////////////////////////
// °°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°//
////////////////////////////////////////////////////////////////////////////////
void Leer_Sagua(){
    
    //printf( " %d  \n ", L_Agua );
    L_Agua = In_Sagua.read_u16(); 
    
    if( L_Agua > 1000 ){
            
            pc.printf( " Se paso \n " );
            Lemer = 1;
            BUZZ.period_us( 1300 );
            BUZZ.write( 0.8 );
            wait( 0.5 );
            BUZZ.write( 0 );
            Lemer = 0;
            wait( 0.5 );
    }    
        
}
////////////////////////////////////////////////////////////////////////////////
// °°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°°//
////////////////////////////////////////////////////////////////////////////////
void Funciones_Mezcladora(char _Funcion){  
    
    switch (_Funcion){
        
        //Llenar agua
        case 'A':
        
            Llenado = 1;
            //printf(" Caso 1 ");
            
            
        break;
        
        //Expulsar agua
        case 'B':
        
            Sacado = 1;
            //printf(" Caso 2 ");
            
        break;
            
        case 'C':
        
            t1.start();
            
        break;
        
        case 'D':
        
            t1.stop();
            NVIC_SystemReset();
            
        break;
        
        case 'E':
        
            Llenado = 0;
            //printf(" Caso 5 ");
            
            
        break;
        
        //Expulsar agua
        case 'F':
        
            Sacado = 0;
            led = 0;
            //printf(" Caso 6 ");
            
        break;
    }
}