#include "mbed.h"
#include <stdint.h>
#include <stdbool.h>
#include "nrf51.h"
#include "nrf51_bitfields.h"
#include "ble_dtm.h"
#include "nrf_gpio.h"
#include <stdio.h>
#include "MPU6050.h"
#include "BLEDevice.h"


// DFUService is already included & automatically advertised by the mbed lib dependancies (currently)

const static char     DEVICE_NAME[]        = "Hello_LinkSprite";

BLEDevice ble;

DigitalOut myled(LED1);

MPU6050 mpu(0x69);
int16_t ax=0, ay=0, az=0;
int16_t gx=0, gy=0, gz=0;
int moyZ=0;                 //global Z value (mean)
int16_t moy[64];            //array of different measurements


//DigitalOut myled(LED2);

// Configuration parameters.
#define BITRATE         UART_BAUDRATE_BAUDRATE_Baud9600  /**< Serial bitrate on the UART */
#define TX_PIN_NUMBER   0 /**< Use proper value for your hardware */
#define RX_PIN_NUMBER   1 /**< Use proper value for your hardware */
#define MAX_ITERATIONS_NEEDED_FOR_NEXT_BYTE 21
/**@brief Function for UART initialization.
 */
static void uart_init(void)
{
    // Configure UART0 pins.
    nrf_gpio_cfg_output(TX_PIN_NUMBER);
    nrf_gpio_cfg_input(RX_PIN_NUMBER, NRF_GPIO_PIN_NOPULL);

    NRF_UART0->PSELTXD       = TX_PIN_NUMBER;
    NRF_UART0->PSELRXD       = RX_PIN_NUMBER;
    NRF_UART0->BAUDRATE      = BITRATE;

    // Clean out possible events from earlier operations
    NRF_UART0->EVENTS_RXDRDY = 0;
    NRF_UART0->EVENTS_TXDRDY = 0;
    NRF_UART0->EVENTS_ERROR  = 0;

    // Activate UART.
    NRF_UART0->ENABLE        = UART_ENABLE_ENABLE_Enabled;
    NRF_UART0->INTENSET      = 0;
    NRF_UART0->TASKS_STARTTX = 1;
    NRF_UART0->TASKS_STARTRX = 1;
}



void moyennage_Z()              //calculates the mean value by going through the whole array, sum and divide by the sample size (64)
{
    for (int n=0; n<64; n++) 
    {
        moyZ=moyZ+moy[n];
    }
    moyZ=(int)moyZ/64;
}


const uint8_t MPU6050_service_uuid[] = {
    0x45,0x35,0x56,0x80,0x0F,0xD8,0x5F,0xB5,0x51,0x48,0x30,0x27,0x06,0x9B,0x3F,0xD9
};

const uint8_t MPU6050_Accel_Characteristic_uuid[] = {
    0x45,0x35,0x56,0x81,0x0F,0xD8,0x5F,0xB5,0x51,0x48,0x30,0x27,0x06,0x9B,0x3F,0xD9
};


uint8_t accelPayload[sizeof(int16_t)*6] = {0,};

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}

GattCharacteristic  accelChar (MPU6050_Accel_Characteristic_uuid,
                                        accelPayload, (sizeof(int16_t) * 6), (sizeof(int16_t) * 6),
                                        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

GattCharacteristic *ControllerChars[] = { &accelChar };
GattService         MPU6050Service(MPU6050_service_uuid, ControllerChars, sizeof(ControllerChars) / sizeof(GattCharacteristic *));



int16_t exchange_position(int16_t temp)
{
    int16_t i = temp ;
    
    temp = temp>>8;
    temp = (i<<8) | temp;
            
    return temp;
}

void updata_values()
{
    //int16_t value_test = 100;
    
    //value_test = exchange_position(value_test);
    

    mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
        
        
    ax = exchange_position(ax);
    ay = exchange_position(ay);
    az = exchange_position(az);
    gx = exchange_position(gx);
    gy = exchange_position(gy);
    gz = exchange_position(gz);
      
    //memcpy(accelPayload+sizeof(int16_t)*0, &value_test, sizeof(value_test));
    
    memcpy(accelPayload+sizeof(int16_t)*0, &ax, sizeof(ax));
    memcpy(accelPayload+sizeof(int16_t)*1, &ay, sizeof(ay));
    memcpy(accelPayload+sizeof(int16_t)*2, &az, sizeof(az));
    memcpy(accelPayload+sizeof(int16_t)*3, &gx, sizeof(gx));
    memcpy(accelPayload+sizeof(int16_t)*4, &gy, sizeof(gy));
    memcpy(accelPayload+sizeof(int16_t)*5, &gz, sizeof(gz));
    
    ble.updateCharacteristicValue(accelChar.getValueAttribute().getHandle(), accelPayload, sizeof(accelPayload));    //Mod
    
    wait(0.1);
}






/**@brief Function for application main entry.
 *
 * @details This function serves as an adaptation layer between a 2-wire UART interface and the
 *          dtmlib. After initialization, DTM commands submitted through the UART are forwarded to
 *          dtmlib and events (i.e. results from the command) is reported back through the UART.
 */
int main(void)
{  
    
    int16_t test = 0x6400;
    int16_t LinkSprite = 0;
    LinkSprite = exchange_position(test);
        
    ble.init();
    ble.onDisconnection(disconnectionCallback);

    /* Setup advertising. */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
   // ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
//    ble.setAdvertisingInterval(Gap::MSEC_TO_ADVERTISEMENT_DURATION_UNITS(1000));
 //   ble.startAdvertising();
    
    
       
    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (const uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)MPU6050_service_uuid, sizeof(MPU6050_service_uuid));
                                    //(const uint8_t *)MPU6050_adv_service_uuid, sizeof(MPU6050_adv_service_uuid));

    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    ble.addService(MPU6050Service);
       
    uart_init();
         
 //    Thread thread(mon_thr);
    printf("MPU6050 test\n\n\r");               //procedure to test the connection to the mpu6050, if valid
    printf("MPU6050 initialize \n\r");          //the code to execute is embedded in a if{}
    mpu.initialize();
    printf("MPU6050 testConnection \n\r");
    bool mpu6050TestResult = mpu.testConnection();
    
    if(mpu6050TestResult) 
    {
      
      printf("MPU6050 test passed \n\r");
      
      while(1) 
          {
                 /*     
                myled = 0;             
                wait(0.2);
                myled = 1;
                wait(0.2);
            
                wait(1);
                
                */
                printf("hello LinkSprite123 \r\n");
                
                printf("LinkSprite test = 0x%x \r\n\n\r", LinkSprite);
                
                
               
                
                /* Uncomment below if you want to see accel and gyro data */
                 /*
                 for (int n=0; n<64; n++) 
                 {                          //refreshing the 64-int16 array
                        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
                        moy[n]=az;
                        wait(0.01);
                 }
                 
                 */
                 
                 updata_values();
                 wait(0.1);
                 
                moyennage_Z();                                      //calculating the mean value by a simple sum and divide
                printf("%i\n\r",moyZ+17000);
                printf("ax = %d, ay = %d, az = %d, gx = %d, gy = %d, gz = %d\n\r", ax,ay, az, gx, gy, gz);
                wait(0.1);
                printf("hello LinkSprite456 \r\n");
              
          }
     }
     
     else 
     {
        printf("MPU6050 test failed \n\r");
     }        
}

