
#include "Global.h"

#define FOSC                        12000000                            

#define FCCLK                      (FOSC  * 8)                          
                                                                       
#define FCCO                       (FCCLK * 3)                          
                                                                       
#define FPCLK                      (FCCLK / 4)  

#define UART0_BPS    38400



unsigned int BuffOut[1024];

unsigned int InputIndexBO;
unsigned int OutputIndexBO;



unsigned int BuffIn[1024];

unsigned int InputIndexBI;
unsigned int OutputIndexBI;

//unsigned int OLD_OutputIndex;



void UART0_Init_m (void)///�������������� �������� �����
{
	uint16_t usFdiv;
    /* UART0 */
    LPC_PINCON->PINSEL0 |= (1 << 4);             /* Pin P0.2 used as TXD0 (Com0) */
    LPC_PINCON->PINSEL0 |= (1 << 6);             /* Pin P0.3 used as RXD0 (Com0) */
  
  	LPC_UART0->LCR  = 0x83;                     
    usFdiv = (FPCLK / 16) / UART0_BPS;           
    LPC_UART0->DLM  = usFdiv / 256;
    LPC_UART0->DLL  = usFdiv % 256; 
    LPC_UART0->LCR  = 0x03;                      
    LPC_UART0->FCR  = 0x06; 				   
}

int UART0_SendByte_m (int ucData)
{
	//while (!(LPC_UART0->LSR & 0x20)){};

  return (LPC_UART0->THR = ucData);
}
void ClearBuffout(void) //������� ������ �� ������(����� ����������)
{
	InputIndexBO=0;
	OutputIndexBO=0;
}
void SendToBuffByte(unsigned int *input) // ������ � ����� �� ������ ������ �������� ���(������������)
{
      InputIndexBO++;
			InputIndexBO &= 0x3ff;
	    BuffOut[InputIndexBO]=*input;
}
void SendToBuff(unsigned char *input, unsigned int size)//������ ���������� �������� � ��������� ����������� ������ � ����� �� ������.
{
	unsigned int i;
	for(i=0;i<size;i++)
	{
			InputIndexBO++;
			InputIndexBO &= 0x3ff;
			BuffOut[InputIndexBO]=*input++;
	}	
}


void SendToBuffStr1(char *s)//������ ������ (����� ������������� �� ����) � ����� �� ������.
{
 	while (*s != 0) 
	{
			InputIndexBO++;
			InputIndexBO &= 0x3ff;
			BuffOut[InputIndexBO]=*s++;
	}
}


void TakeFromBuff(void)//�������� ��  ������ �� ������.
{
	if((OutputIndexBO != InputIndexBO) && (LPC_UART0 -> LSR & 0x20))
	{
			OutputIndexBO++;
			OutputIndexBO &= 0x3ff;
			LPC_UART0->THR = BuffOut[OutputIndexBO];
	}
}

/*
void UART0_SendString (char *s) 
{
 	while (*s != 0) 
	{
			InputIndex++;
			InputIndex &= 0x3ff;
			BuffOut[InputIndex]=*s++;
	}
}
*/

void ClearBuffIn(void)
{
	InputIndexBI=0;
	OutputIndexBI=0;
}

void BuffDataReady(void)
{
	if((OutputIndexBI != InputIndexBI) && (!(LPC_UART0 -> LSR & 0x01)))
	{
		
	}
}
void ReadDataInBuff(void)
{
     while (LPC_UART0->LSR & 0x01)
     {
  	  BuffIn[InputIndexBI] = LPC_UART0->RBR;
		  InputIndexBI++;
		 }
}

















