#ifndef CntrlGLD_H
#define CntrlGLD_H


//e. constants for the piecewise-linear thermocompensation //r. ��������� ��� �������-�������� ����������������
#define 	TERMO_FUNC_SIZE		14 	//e. amount of the points of the table function of thermocompensation //r. ���������� ����� ��������� ������� ����������������
#define 	MAX_ORDER			9   //e. maximal value of order for the thermocompensation coefficients //r. ������������ �������� ������� ��� ������������� ����������������
#define 	TSENS_NUMB			4   //e. number of the temperature sensor used for the thermocompensation //r. ����� ������������, ������������� ��� �����������

typedef enum _TERMO_MODE   //e. thermocompensation modes //r. ������ ������ ����������������
{
	TERMO_OFF,						//e. thermocompensation is switched off  //r. ���������������� ���������
	TERMO_ON,						//e. thermocompensation is switched on  //r. ���������������� ��������
	TERMO_ON_NUMB_OFF,				//e. thermocompensation is switched on, number resets (debug mode) //r. ���������������� ��������, ����� ���������� (���������� �����)
	TERMO_ON_STATIC_ONLY,			//e. only static thermocompensation is switched on  //r. �������� ������ ����������� ����������������
	TERMO_ON_DYNAMIC_ONLY,			//e. only dynamic thermocompensation is switched on  //r. �������� ������ ������������ ����������������
	TERMO_ON_STATIC_ONLY_NUMB_OFF,	//e. static thermocompensation is switched on, number resets (debug mode) //r. ����������� ������������������������, ����� ���������� (���������� �����)
	TERMO_ON_DYNAMIC_ONLY_NUMB_OFF	//e. dynamic thermocompensation is switched on, number resets (debug mode) //r. ������������ ������������������������, ����� ���������� (���������� �����)
} TERMO_MODE;

typedef enum _WATCH_MODE   //e. variants of control points for scope //r. �������� ����������� ����� ��� ������������
{
	VB_DELAY_MEANDER,			//e. the delayed on the VB_phs meander //r. ����������� ������ �� �������� VB_phs
	VB_PHASE_DETECTOR,			//e. output of the PD of the dither drive //r. ����� �������� ��������� ������������
	VB_PHASE_DETECTOR_1_SEC,	//e. output of integral of the PD of the dither drive for 1 Sec //r. ����� ��������� �� ������������ �� 1 ���
	VB_INTEGRATOR_40T,			//e. output of integral of the PD of the dither drive for 40 periods //r. ����� ��������� �� ������������ �� 40 ��������
	WP_PHASE_DETECTOR  			//e. output of the PD of the CPLC regulator //r. ����� �������� ��������� ������� ���
} WATCH_MODE;

//e. =====  device operation modes ================================================================ //r. ===== ������ ������ ������� ================================================================
#define  DM_INT_10KHZ_LATCH				1		//e. mode of internal latch 10 kHz //r. ����� ���������� ������� 10 ���			
#define  DM_INT_LATCH_DELTA_PS			2
#define	 DM_INT_LATCH_DELTA_BINS		3
#define  DM_EXT_LATCH_DELTA_PS_PULSE	4		//e. mode of external latch with output of the Delta_PS command by pulse //r. ����� ������� ������� � ������� ������� Delta_PS �� ��������
#define  DM_EXT_LATCH_DELTA_BINS_PULSE	6		//e. mode of external latch with output of the Delta_BINS command by pulse//r. ����� ������� ������� � ������� ������� Delta_BINS �� ��������
#define  DM_EXT_LATCH_DELTA_SF_PULSE	7		//e. mode of Delta Scale factor //r. ����� Delta_SF command
 
  //e. *** the BLOCK of VARIABLES, LOADED from FLASH-memory ********************** //r. *** ���� ����������, ����������� �� FLASH-������ ********************** 
      	//e. Address (parameter number in the block = 0..255 ) //r. ����� (����� ��������� � ����� = 0..255)
typedef  union
 {
   int Array[171];
  struct 
  {   					// Device_blk
	int     My_Addres;      //e. 0 - device own address //r.0 - ����������� ����� ����������
 
                //e. =============== parameters of HFO regulator ===============    //r. =============== ��������� ������� �� ���������� ������� ===============       
	int		  HF_ref;    		  //e. 1 - value of the reference //r.  1 - �������� �����  
	int     HF_scl;         //e. 2 - the gain factor (1.15)    //r. 2 - ����������� �������� (1.15)
	int     HF_min;         //r.  3 - ������� ��������� �������� �� ���� ���������� (������������� ������. ���������� �� ���)
	int     HF_max;         //e. 4 - maximum of the output value on the regulator DAC (appropriate to minimal voltage on the HFO) //r.  4 - �������� ��������� �������� �� ���� ���������� (������������� �����. ���������� �� ���)

                //e. =============== parameters of the regulator of the DS power regulator ========== //r. =============== ��������� ������� ������������� �������� ��� ==========
	int     RI_ref;         //e. 5 - value of the reference //r.  5 - �������� �����
	int     RI_scl;         //e. 6 - the gain factor (1.15) //r.  6 - ����������� �������� (1.15)

                //e. =============== parameters of the CPLC regulator ===== //r. =============== ��������� ������� ������������ �������� ��������� (���) =====
	int     WP_ref;         //e. 7 -  value of the reference //r.  7 - �������� �����
	int     WP_scl;         //e. 8 - the gain factor (1.15) //r. 8 - ����������� �������� (1.15)
	int     WP_mdy;         //e. 9 - value of the reset delay //r. 9 - �������� �������� ������
	int     WP_rup;         //e. 10 - upper value of DAC adjustment (appropriate to minimal voltage on the heater) //r. 10 - ������� �������� ����������� ��� (������������� �����. ���������� �� �����������)                                     
	int     WP_rdw;         //e. 11 - lower value of the DAC adjustment (appropriate to maximal voltage on the heater) //r. 11 - ������� �������� ����������� ��� (������������� ������. ���������� �� �����������)
	
                //e. =============== parameters of the dither drive regulator of the GLD ==================== //r. =============== ��������� ������� ������������ ��� ==================== 
	int     VB_phs;         //e. 12 - the phase delay parameter of the dither drive PLL //r.  12 - �������� Phase_���. ��� ������������
	int     VB_scl;         //e. 13 - the gain factor (1.15) of the dither drive PLL  //r. 13 - ����������� �������� (1.15) ��� ������������
unsigned int VB_N;          //e. 14 - divider for dither drive period (defines dither period) //r. 14 - �����.������� N ������������ (������ ���������) ��
unsigned int VB_Nmin;        //e. 15 - minimum of the output value of the oscillation period regulator //r. 15 - ������� ��������� �������� ���������� ������� 
unsigned int VB_Nmax;        //e. 16 - maximum of the output value of the oscillation period regulator //r. 16 - �������� ��������� �������� ���������� �������

	int     VB_Fdf_Hi;      //e. 17 - adjusted output frequency (H) //r. 17 - �������� ������� ����������� (H)
unsigned int VB_Fdf_Lo;      //e. 18 - (L) (double precision) //r. 18 - (L) (������� ��������)                      

	int     VB_Fsc;         //e. 19 - the gain factor of the frequency regulator //r. 19 - ����������� �������� ���������� ������� �����������                  
unsigned int VB_Tmin;        //e. 20 - the gain factor of the frequency regulator //r. 19 - ����������� �������� ���������� ������� �����������
unsigned int VB_Tmax;        //e. 21 - maximum of the output value of the regulator //r. 21 - �������� ��������� �������� ���������� Tau
unsigned int VB_tau;         //e. 22 - pulse width of the dither drive (without noise)//r. 22 - ������������ �������� ������������ (�� ���������)
	int     VBN_Tzd;        //e. 23 - adjusted noise period //r. 23 - �������� ������ ���������
	int     VBN_Ran;        //e. 24 - range of the random component of noise //r. 24 - �������� ��������� ������������ ��������� VBN_Tsl                               
	int     VBN_k;          //e. 25 - adjusted noise constant //r. 25 - �������� ��������� ���������

                //e. =============== parameters of processing of accurate data ============= //r. =============== ��������� ��������� ���������� ���������� =============
	int     PI_Fsc; //_        //e.  26 - the S_ds scale parameter //r.  26 - ���������� ����������� S���
	int     PI_Fb0; //_        //e.  27 - the B_ds zero shift of the DS //r.  27 - �������� ���� ���� B���
	int     PI_scl; //_        //e.  28 - the Scale scale coefficient of the gyro //r.  28 - ���������� �����. ��������� Scale
	int     PI_bia; //_        //e.  29 - the Bias zero shift of the gyro //r.  29 - �������� ���� ��������� Bias

                //e. ===============  coefficients of the temperature correction ================= //r. ===============  ������������ ������������� ��������� =================
	int     PI_a0; //_         //  30
	int     PI_a1; //_         //  31
	int     PI_a2; //_         //  32
	int     PI_a3; //_         //  33 
	int     PI_a4; //_         //  34
	int     PI_a5; //_         //  35
	int     PI_a6; //_         //  36
	int     PI_b1; //_         //  37
	int     PI_b2; //_         //  38
	int     PI_b3; //_         //  39
	int     PI_b4; //_         //  40
	int     PI_b5; //_         //  41
	int     PI_b6; //_         //  42

                //e. =============== parameters of normalization of the temperature sensors  ============= //r. =============== ��������� ���������� �������� ����������� =============

	int     Tmp_bias[6]; //_  //e. 43 - an array of shifts of the 0..5 temperature sensors //r. 43 - ������ ������� ������������� �������� 0..5
	int     Tmp_scal[6]; //_  //e. 49 - an array of the scale coefficients of temperature sensors//r.  49 - ������ ���������� �-��� ������������� �������� 
	int     WP_reset;       //e. 55 - initial position of the CPLC regulator (after reset)  //r.  55 - �������� ��������� ���������� ��� (����� ������)
				
				//e. ================ gain factor of photodetector channels =========== //r. ================ �-� �������� ������� ������������� ===========
unsigned int	Gain_Ph_A;		//e. 56 - initial gain factor of the A channel of photodetector //r.	56 - ��������� �-� �������� ������ � �������������
unsigned int	Gain_Ph_B;		//e. 57 - initial gain factor of the B channel of photodetector //r. 57 - ��������� �-� �������� ������ B �������������
		
				//e. =============== switch of the source of loading GLD variables block === //r. =============== ������������� ��������� �������� ����� ���������� ��� (������� � ������������ ���������)
	int		Header_Word;			//e. 58 - flash sector validity header  //r. 58 - ���������-���� � ���������� ��������� ��������
	int		LoadFlash_enable;		//e. 59 - source loading flag: 1 - load from the flash //r. 59 - ������� ��������� ��������: 1 - ��������� �� flesh
																//e. 0 - load default parameters (factory)  //r. 0 - ������� ��������� �� ��������� (���������)
unsigned int Device_SerialNumber;		//e. 60 - serial number of the device //r. 60 - �������� ����� �������
	int     Reserved0;       //e. 61 - not used
	TERMO_MODE	TermoMode;	//e  62 - device operation mode (with thermocompenstion, without it, debug )//r.  62 - ����� ������ ������� (� �����������������, ��� ��� ��� �������)
//e. addition for the piecewise-linear termocorrection //r. ���������� ��� �������-�������� ��������������
	int 	TemperInt[TERMO_FUNC_SIZE];	//e. 63 
	float 	TermoFunc[TERMO_FUNC_SIZE];	//e. 77
	int     WP_reset2;       //e. 91 - voltages of CPLC regulator reset at cooling //r.  xx - ���������� ��������� ������� ��� ��� ����������
	//e. parameters setting termocompensation parameters in dynamics (at heating and cooling) //r. ���������, �������� ��������� ���������������� � �������� (��� ������� � ����������)
	float	Reserved1; //e. 92 - not used
	float	Reserved2; //e. 93 - not used
	int		K_vb_tu; 			//e. 94 - slope of dependence of the VB_N division factor from temperature (as though Hz/degree, but in relative units ) //r. �������� ����������� ������������ ������� VB_N �� ����������� (��� �� ��/������, �� � �.�.)
	int		TemperNormal; 		//e. 95 -temperature for which the VB_N division factor of the dither drive is set //r. �����������, ��� ������� ����� ����������� ������� ������������ VB_N
	int		K_WP_rst_heating; 	//r. 96 - �������� ����������� ���������� ��������� ��� ���������� �� ����������� (��� �� �����/������, �� � �.�. ��� � ������������� )
	int		K_WP_rst_cooling; 	//e. 97 - slope of dependence of a reset voltage at cooling from temperature (as though Volt/degree, but in relative units of DAC and temperature sensors)  //r. �������� ����������� ���������� ��������� ��� ���������� �� ����������� (��� �� �����/������, �� � �.�. ��� � ������������� )
	int		WP_transition_step; //e. 98 - step of change of a heater voltage at resetting //r. ��� ��������� ���������� ����������� ��� ���������� ���������
	int		Reserved3; // e. 99 -not used
	int     HF_scl_2;         //r. 100 -  ����������� �������� (1.15) ������� ��� ��� ���������
	int 	TemperIntDyn[TERMO_FUNC_SIZE]; //e. 114 - 
    float   ThermoHeatDelta[TERMO_FUNC_SIZE]; //e. 128 - 
    int     DeltaTempRecalc;   //r. 129 - ������������� �������� ��������� �������. ����������� (� �.�.) //e. temperature delta for dynamic thermocompensation recalculation(in relative units)
	int 	TemperCoolIntDyn[TERMO_FUNC_SIZE]; // e. 143 - 
    float   ThermoCoolDelta[TERMO_FUNC_SIZE];  //e. 157 - 
 } Str;
} TDEVICE_BLK;











//e. ************ end of the BLOCK of VARIABLES, LOADED from FLASH-memory ************ //r. ************ ����� ����� ����������� �� ����-������ ���������� ��� ************
extern 	TDEVICE_BLK Device_blk; //e. the BLOCK of VARIABLES, LOADED from FLASH-memory //r. ���� ����������, ����������� �� FLASH-������

extern 		 int Device_Mode;
extern 	unsigned Valid_Data;

extern	unsigned ser_num;

extern		 int VB_Nmin0;  //r. �������  ��������� �������� ���������� ������� ��� ����������� Device_blk.TemperNormal
extern		 int VB_Nmax0;  //r. �������� ��������� �������� ���������� ������� ��� ����������� Device_blk.TemperNormal

extern  unsigned BIT_number;
extern  unsigned Is_BIT; 

extern	unsigned start_Rq;       //r. ������ �� ������ �������
extern	unsigned stop_Rq;        //r. ������ �� ������� �������
extern	unsigned pulse_Rq;       //r. ������ �� ������ ������

	//r. *** ��������� ��������� �� ��������� ***
#define	DEVICE_SN			1		       //r. �������� ����� ������� = 01
#define	My_Addres_const		0	     //r.   - ����������� ����� ���������� 
 
	//r. ====== ��������� ������� �� ���������� ������� ===============  
	
	#define	HF_REF_CONST	15080	   //r.  1 - �������� �����  
	#define	HF_SCL_CONST	1	       //r. 2 - ����������� �������� (1.15)                              
	#define	HF_MIN_CONST	-32668   //r.  3 - ������� ��������� �������� �� ���� ���������� (������������� ������. ���������� �� ���)
	#define	HF_MAX_CONST    -17379 //r.  4 - �������� ��������� �������� �� ���� ���������� (������������� �����. ���������� �� ���)
	#define	HFO_SHIFT		16		     //r. ����� �������� ������� ����� � 32-�������� ���������� hf_reg32

	//r. ====== ��������� ������� ������������ �������� ��������� (���) =====
	
	#define	WP_REF_CONST	5         //r.  7 - �������� �����                                                  
	#define	WP_SCL_CONST	5	        //r. 8 - ����������� �������� (1.15)
	#define	WP_MDY_CONST	30		    //r. 9 - �������� �������� ������                                        
	#define	WP_RUP_CONST	31936   	//r. 10 - ������  �������� ����������� ��� (������������� �����. ���������� �� �����������)                                     
	#define	WP_RDW_CONST	11801	    //r. 11 - ������� �������� ����������� ��� (������������� ������. ���������� �� �����������)
 
     	
//r. =============== ��������� ������� ������������ ��� ==================== 

	#define	VB_PHS_CONST	4     	//r.  12 - �������� Phase_���. ��� ������������        
	#define	VB_SCL_CONST	1024	  //r. 13 - ����������� �������� (1.15) ��� ������������
	#define	T_VIB_START     16600	//r. 14 - �����.������� N ������������ (������ ���������) ��
								 //r. _VB_N ��������� ������ ��������� ������������ (406Hz-18916, 17067 - 450Hz)  
	#define	T_VIB_DELTA	    1000	//r. �������� ��������� ������� ��������� ������������ (~ +/- 10 Hz)

	#define	VB_NMIN_CONST   12080	    //r. 15 - ������� ��������� �������� ���������� ������� 
	#define	VB_NMAX_CONST   64000	    //r. 16 - �������� ��������� �������� ���������� �������
	#define	VB_FDF_HI_CONST	3	        //r. 17 - �������� ������� ����������� (H)                     
	#define	VB_FDF_LO_CONST	0  	    	//r. 18 - (L) (������� ��������)                      
	#define	VB_FSC_CONST	-2000	      //r. 19 - ����������� �������� ���������� ������� �����������                  
	#define	VB_TMIN_CONST	100	        //r. 20 - ������� ��������� �������� ���������� Tau                           
	#define	VB_TMAX_CONST	10022	      //r. 21 - �������� ��������� �������� ���������� Tau                  
	#define	L_VIB_START      5120	    //r. 22 - ������������ �������� ������������ (�� ���������)
								 //r. _VB_tau ��������� ������������ �������� ������������      

	#define	VBN_TZD_CONST	500     //r. 23 - �������� ������ ��������� (��������� ������������)
	#define	VBN_RAN_CONST	400     //r. 24 - �������� ��������� ������������ ��������� VBN_Tsl                               
	#define	VBN_K_CONST  	7000	//r. 25 - �������� ��������� ��������� (��������� ������������)

   //r. =============== ��������� ������� ������������� �������� ��� ==========
	#define	RI_REF_CONST	25600	//r.  5 - �������� �����                                                
	#define	RI_SCL_CONST	0	    //r.  6 - ����������� �������� (1.15)
	
               
                //r. =============== ��������� ��������� ���������� ���������� =============
	#define	PI_FSC_CONST	128	    //r.  26 - ���������� ����������� S���
	#define	PI_FB0_CONST	0	    //r.  27 - �������� ���� ���� B���
	#define	PI_SCL_CONST	256	    //r.  28 - ���������� �����. ��������� Scale
	#define	PI_BIA_CONST	0	    //r.  29 - �������� ���� ��������� Bias

               //r. ===============  ������������ ������������� ��������� =================
	#define	PI_A0_CONST		0	//  30
	#define	PI_A1_CONST		0	//  31
	#define	PI_A2_CONST		0	//  32
	#define	PI_A3_CONST		0	//  33 
	#define	PI_A4_CONST		0	//  34
	#define	PI_A5_CONST		0	//  35
	#define	PI_A6_CONST		0	//  36
	#define	PI_B1_CONST		0	//  37
	#define	PI_B2_CONST		0	//  38
	#define	PI_B3_CONST		0	//  39
	#define	PI_B4_CONST		0	//  40
	#define	PI_B5_CONST		0	//  41
	#define	PI_B6_CONST		0	//  42

	#define TMP_SCALE		0x4000 // 43 - 54  Tmp_bias[6]; Tmp_scal[6]
	#define TMP_BIAS		0
	#define	WP_RESET_CONST 7360	// 55
	#define WP_RESET2_CONST 29216
	#define WP_TRANS_STEP	32767		
//r. ================ ��������� �-� �������� ������� ������������� ===========
	#define	G_PHOTO_STRA	60     // 56 
	#define	G_PHOTO_STRB  	60		// 57

	 //r. =============== ������������� ��������� �������� ����� ���������� ��� ===
	#define HEADER_WORD_CONST	0x55aa	//r. 58 - ���������-���� � ���������� ��������� ��������
              
#define  DITHER_REG_PERIOD		40	 //r. ������ ������������� ����������� (� �������� ������������)

#define  PLC_RESET_THRESHOLD 	(-3276)  //r. ������������� ���������� +1.2 ������	

//r. ���.���������� ������� �����������, ��� ���. ������ ��������� ������������
#define		F_RAS_MIN	    10000 	//r.  ����������� ������� ����������� ��� ������
#define		F_OUT_MIN		(5000>>4)  	//   5000 �� / 16
#define		F_OUT_NORM		(70000>>4)  	//  90000 �� / 16
#define		F_OUT_MAX		(300000>>4) 	// 300000 �� / 16

#define		Set_LightUp		LPC_GPIO0->FIOSET = (1<<4)	//set light up signal
#define		Reset_LightUp	LPC_GPIO0->FIOCLR = (1<<4)	//reset light up signal
	
	//r. ��������� ��� �������-�������� ����������������
#define 	TERMO_FUNC_SIZE		14 	 //r. ���������� ����� ��������� ������� ����������������
#define 	MAX_ORDER			9    //r. ������������ �������� ������� ��� ������������� ����������������
#define 	TSENS_NUMB			4   //r. ����� ������������, ������������� ��� �����������

#define	    VALID_START_4SEC		3 //r. ����� ����� ������, ����� ����������� ����� �����������

#define		N_START_MAX     	1 // 4        //r. ����� ������� ������� �������
#define		LIGHT_UP_PULSE_WDTH 5000 //1000 //e. width of light-up pulse = 100 msec
#define		LIGHT_UP_PAUSE		1000          //e. pause after light-up = 100 msec
#define		LIGHT_UP_POLLING	10000         //e. time of waiting laser generation = 1 sec

	// Status word errors bits
#define		OUT_FREQ_ERROR		0x8000
#define		DITH_FREQ_ERROR		0x4000
#define		HFO_VOLT_ERROR		0x2000
#define		THERMO_RANGE_ERROR	0x1000
#define		THERMO_DIFF_ERROR	0x0800

#define		TS_MIN				-2500 	// minimal temperature for our thermal sensors
#define		TS_MAX				+13000  // maximal temperature for our thermal sensors
#define		TS_DIFF_MAX			1300	// maximal difference between 2 thermal sensors

#define		HFO_NEG_MIN			8738	// -4.5 V
#define		HFO_NEG_MAX			25122	// -10.5 V
#define		HFO_POZ_MIN			-32221	// +10.5 V
#define		HFO_POZ_MAX			-15837 	// +4.5 V

//e. ================ bits of the main register (_RgConA) of GLD control ==============
		//r. ================ ���� ��������� �������� ���������� GLD (_RgConA) ===============
        //e. ================ (bits of the status register) ============================
        //r. ================ (��� �� - ���� �������� ���������) ============================
#define  LASER_ON        0x0001  		 //r. ���./����. ��������� ������
#define  HF_REG_ON       0x0002  		 //r. ���./����. ������ ���  
#define  RI_REG_ON       0x0004  		 //r. ���./����. ������ �������� ���   
#define  WP_REG_ON       0x0008  	   //r. ����� ���./����. ������� ���  
#define  WP_SIN_ON       0x0010  		 //r. ���./����. ��������� ������ ���  
#define  VB_TAU_ON       0x0020  		 //r. ���./����. ������ ��������� ����������� 
#define  VB_FREQ_ON      0x0040  		 //r. ���./����. ������ ������� ������������
#define  GLD_ON          0x0080  		 //r. ���./����. ���� ���

	// Status word errors bits
#define		OUT_FREQ_ERROR		0x8000
#define		DITH_FREQ_ERROR		0x4000
#define		HFO_VOLT_ERROR		0x2000
#define		THERMO_RANGE_ERROR	0x1000
#define		THERMO_DIFF_ERROR	0x0800

#define loop_is_closed(loop_bit) 	((RgConA & (loop_bit)) == loop_bit)
#define close_loop(loop_bit) 		RgConA |= loop_bit
#define open_loop(loop_bit) 		RgConA &= ~(loop_bit)
	//r. ��������� ��� ������� �������������
#define open_all_loops()			RgConA   = 0	
#define close_all_loops()			RgConA   = 0xFFFF

extern unsigned    SRgR;             //r.���������� �������� ������ ����� ADSP

extern unsigned 	RgConA;            //r. �������� ������� ���������� ����������
extern unsigned 	RgConB;            //r. �������������� ������� ����������
//extern unsigned		Copy_e5_RgR;     //r. ����� �������� ������ ����� E5
//extern unsigned		Copy_e5_RgRA;    //r. ����� ��������������� �������� ������ E5

void contrl_GLD(void);

#endif


