#include "Global.h"


/******************************************************************************
** Function name:		LoadFlashParam
**
** Descriptions:		Load of the parameters from the flash memory 
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void LoadFlashParam(unsigned source) 
{
  if (source == FromFLASH) 
  {  
   	 while (LPC_GPDMACH3->CConfig & (1<<17));      	   //e. wait while DMA channel3 is busy

     if (LPC_GPDMA->RawIntErrStat & INT_ERR_TC) 
	 	 	LPC_GPDMA->IntErrClr |= INT_ERR_TC;	 	   //e. an errors found, reset interrupt

     else if (LPC_GPDMA->RawIntTCStat & INT_ERR_TC) 
	 {  //e. successful loading complete
	    LPC_GPDMA->IntTCClear |= INT_ERR_TC;
       if (Device_blk.Str.Header_Word == HEADER_WORD_CONST) //e. flash contain valid data  	       
	    return;
	 }
	 else 
	 {  					//e. transfer was not started, start it immediatly
	   FlashDMA_Init();
	  return;
	 }
     init_DefaultParam();		//e. load parameters by default 								 									 
  }								
   else  //e. source == ByDefault
	   init_DefaultParam();		//e. load parameters by default 

  blt_in_test = ((uint32_t)FIRMWARE_VER << 8) | (Device_blk.Str.Device_SerialNumber & 0x00FF);
}
/******************************************************************************
** Function name:		init_DefaultParam
**
** Descriptions:		Initialization of variables of computing procedures 
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void init_DefaultParam(void)      
{
	int i;
        
		Device_blk.Str.My_Addres = My_Addres_const; //r. 0x00; //e. direct set of the main device address //r. ������ ���������� ��������� ������ �-��

		Device_blk.Str.HF_ref = HF_REF_CONST; //e. set the reference voltage of the HFO //r. ���������� ������� ���������� ���
        Device_blk.Str.HF_scl = HF_SCL_CONST; //e. set the gain factor of HFO integrator to ~ 0.001 //r. ���������� �-� �������� ����������� ��� ~ 0.001
        Device_blk.Str.HF_scl_2 = Device_blk.Str.HF_scl;
        Device_blk.Str.HF_max = HF_MAX_CONST; //e. maximal value of the regulator  //r. ������������ �������� ����������

        Device_blk.Str.HF_min = HF_MIN_CONST; //e. minimal value //r. ����������� ��������
        Device_blk.Str.RI_ref= RI_REF_CONST; //e. set the reference voltage of DS to (=) 1,5 V //r. ���������� ������� ���������� ��� = 1,5 �
        Device_blk.Str.RI_scl= RI_SCL_CONST; //e. set the gain factor of DS integrator to ~ 0.01 //r. ���������� �-� �������� ����������� ��� ~ 0.01

        Device_blk.Str.WP_ref = WP_REF_CONST; //e. set the reference signal of CPLC to ~ 0,01 of maximal input value  //r. ���������� ������� ������ ��� ~ 0,01 �������� ����.
        Device_blk.Str.WP_scl = WP_SCL_CONST; //e. the gain factor of the CPLC regulator ~ 0,001 //r. �-� �������� ������� ��� ~ 0,001
        Device_blk.Str.WP_rup = WP_RUP_CONST; //e. upper value of the heater current //r. ������� �������� ���� �����������
        Device_blk.Str.WP_rdw = WP_RDW_CONST; //e. lower value of the heater current //r. ������ �������� ���� �����������
        Device_blk.Str.WP_mdy = WP_MDY_CONST; //e. maximal delay of the reset //r. ������������ �������� ���������

        Device_blk.Str.VB_phs = VB_PHS_CONST; //e. the phase delay parameter of the PLL //r. �������� Phase_���.
        Device_blk.Str.VB_scl = VB_SCL_CONST;         //e. set the gain factor of the PLL of the dither drive //r. ���������� ����������� �������� ��� ������������
        Device_blk.Str.VB_Fdf_Lo = VB_FDF_LO_CONST;      //e. set the F_del parameter //r. ���������� �������� F���
        Device_blk.Str.VB_Fdf_Hi = VB_FDF_HI_CONST;      //e. set the F_del parameter (120000) //r. ���������� �������� F��� (120000)
        Device_blk.Str.VB_Fsc = VB_FSC_CONST;         //e. set the ScaleTau parameter //r. ���������� �������� ScaleTau
        Device_blk.Str.VB_Tmin = VB_TMIN_CONST;        //e. set minimal value of the Tau regulator //r. ����������� �������� ���������� Tau
        Device_blk.Str.VB_Tmax = VB_TMAX_CONST;        //e. set maximal value of the Tau reulator //r. ������������ �������� ���������� Tau

        Device_blk.Str.VB_N = T_VIB_START;          //e. ... dither drive //r. ������������
        Device_blk.Str.VB_Nmin = T_VIB_START - T_VIB_DELTA;        //e. minimal value of the N regulator //r. ����������� �������� ���������� N
        Device_blk.Str.VB_Nmax = T_VIB_START + T_VIB_DELTA;        //e. maximal value of the N regulator //r. ������������ �������� ���������� N
        Device_blk.Str.VB_tau = L_VIB_START; //e. similarly load th pulse width of the dither drive //r. ���������� ��������� ������������ ��������� ������������

        Device_blk.Str.VBN_Tzd = VBN_TZD_CONST;       //e. adjusted period of {noise}[??] //r. �������� ������ ���������
        Device_blk.Str.VBN_Ran = VBN_RAN_CONST;        //e. the range of the random component //r. �������� ��������� ������������
        Device_blk.Str.VBN_k = VBN_K_CONST;         //e. ajusted of the {noise}[??] constant //r. �������� ��������� ���������

        Device_blk.Str.PI_a0 = PI_A0_CONST;          //e. a0 coefficient of the temperature correction //r. ����������� a0 ������������� ���������
        Device_blk.Str.PI_a1 = PI_A1_CONST;          //e. a1 coefficient of the temperature correction //r. ����������� a1 ������������� ���������
        Device_blk.Str.PI_a2 = PI_A2_CONST;          //e. a2 coefficient of the temperature correction //r. ����������� a2 ������������� ���������
        Device_blk.Str.PI_a3 = PI_A3_CONST;          //e. a3 coefficient of the temperature correction //r. ����������� a3 ������������� ���������
        Device_blk.Str.PI_a4 = PI_A4_CONST;          //e. a4 coefficient of the temperature correction //r. ����������� a4 ������������� ���������
        Device_blk.Str.PI_a5 = PI_A5_CONST;          //e. a5 coefficient of the temperature correction //r. ����������� a5 ������������� ���������
        Device_blk.Str.PI_a6 = PI_A6_CONST;          //e. a6 coefficient of the temperature correction //r. ����������� a6 ������������� ���������
        
        Device_blk.Str.PI_b1 = PI_B1_CONST;          //e. b1 coefficient of the temperature correction //r. ����������� b1 ������������� ���������
        Device_blk.Str.PI_b2 = PI_B2_CONST;          //e. b2 coefficient of the temperature correction //r. ����������� b2 ������������� ���������
        Device_blk.Str.PI_b3 = PI_B3_CONST;          //e. b3 coefficient of the temperature correction //r. ����������� b3 ������������� ���������
        Device_blk.Str.PI_b4 = PI_B4_CONST;          //e. b4 coefficient of the temperature correction //r. ����������� b4 ������������� ���������
        Device_blk.Str.PI_b5 = PI_B5_CONST;          //e. b5 coefficient of the temperature correction //r. ����������� b5 ������������� ���������
        Device_blk.Str.PI_b6 = PI_B6_CONST;          //e. b6 coefficient of the temperature correction //r. ����������� b6 ������������� ���������

        Device_blk.Str.PI_Fsc = PI_FSC_CONST;        //e. the S_ds scale parameter //r. ���������� ����������� S���
        Device_blk.Str.PI_Fb0 = PI_FB0_CONST;        //e. the B_ds zero shift of the DS  //r. �������� ���� ���� B���
        Device_blk.Str.PI_scl = PI_SCL_CONST;        //e. the Scale scale coefficient of the gyro //r. ���������� �����. ��������� Scale
        Device_blk.Str.PI_bia = PI_BIA_CONST;        //e. the Bias zero shift of the gyro //r. �������� ���� ��������� Bias
        
        for (i = 0; i <6 ; i++)
        {
               Device_blk.Str.Tmp_scal[i] = TMP_SCALE;
               Device_blk.Str.Tmp_bias[i] = TMP_BIAS;
        }
		Device_blk.Str.WP_transition_step = WP_TRANS_STEP;
        Device_blk.Str.WP_reset = WP_RESET_CONST;       //e. default initial position = 0 //r. �������� ��������� �� ��������� = 0
		Device_blk.Str.WP_reset2 = WP_RESET2_CONST;
		Device_blk.Str.Gain_Ph_A = G_PHOTO_STRA; //e. load the initial value of the gain factor of photodetectors channels//r. ��������� ��������� �������� �-�� �������� ������� ��������������
		Device_blk.Str.Gain_Ph_B = G_PHOTO_STRB;

		Device_blk.Str.Device_SerialNumber = DEVICE_SN;  //e. serial number of the device is by default written down in the register of self-testing  //r. �������� ����� ������� �� ��������� ���������� � ������� ����������������
		
} // init_DefaultParam
/******************************************************************************
** Function name:		FlashDMA_Init
**
** Descriptions:		Initialisation of DMA channel for flash reading 
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void FlashDMA_Init()
{
	LPC_GPDMACH3->CConfig &= ~DMAChannelEn; 

	LPC_GPDMA->IntTCClear = DMA3_IntTCClear;
	LPC_GPDMA->IntErrClr = DMA3_IntTCClear;

	  /* Ch3 set for M2M transfer from Flash to RAM. */
	  LPC_GPDMACH3->CSrcAddr = 0x40000;	   //e. address of device parameter block in flash memory (22 sec)
	  LPC_GPDMACH3->CDestAddr = (uint32_t)&(Device_blk.Array);//e. address of device parameter block in RAM

	  LPC_GPDMACH3->CControl = ((sizeof(Device_blk.Array))>>2)|SrcBSize_1 |DstBSize_1 
	  							|SrcWidth_32b |DstWidth_32b |SrcInc |DstInc |TCIntEnabl;

	  LPC_GPDMACH3->CConfig = MaskTCInt |MaskErrInt|DMA_MEMORY |DMA_MEMORY |(M2M << 11)| DMAChannelEn;	

  return;
}

