
#include "Global.h"

INPUT Input;
OUTPUT Output;

volatile uint32_t I2CMasterState = I2C_IDLE;
volatile uint32_t I2CMasterBuffer[I2C_WRITELENGTH];

int ExchangeErr = 0;
//----------------------temp---------------------
extern char test;
/******************************************************************************
** Function name:		G_Photo_Exchange
**
** Descriptions:		Driver for I2C exchange
**
** parameters:			None
** Returned value:		None
**
******************************************************************************/

void G_Photo_Exchange(void)
{
    uint32_t StatValue;
    static uint32_t WrIndex;
    static  int32_t time_out = TIMEOUT;

    if (I2CMasterState)
        return;							//e.transmitting is not active, go away

    if (--time_out < 0) {	   //e. valid time period elapsed, go away
        time_out = TIMEOUT;
        I2CMasterState = I2C_IDLE;	 	//e. timer elapsed, go away
        LPC_I2C0->CONSET = I2CONSET_STO;      //e. Set Stop flag
        LPC_I2C0->CONCLR = I2CONCLR_AAC | I2CONCLR_SIC | I2CONCLR_STAC;
        return;
    } else if (!(LPC_I2C0->CONSET & I2CONSET_SI))		//e. state of I2C bus has not been changed
        return;

    StatValue = LPC_I2C0->STAT;

    switch ( StatValue ) {
        case 0x08:			// A Start condition is issued (write data for the first potentiometer)
            WrIndex = 0;
            time_out = TIMEOUT;  //e. enable countdown
            LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];	   //e. send address
            LPC_I2C0->CONCLR = (I2CONCLR_SIC | I2CONCLR_STAC); //e .clear interrupt bit and start bit
            break;

        case 0x10:			// A repeated started is issued (write data for the second potentiometer)
            LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];	   //e. send address
            LPC_I2C0->CONCLR = (I2CONCLR_SIC | I2CONCLR_STAC); //e .clear interrupt bit and start bit
            break;

        case 0x18:			//e. Regardless, it's a ACK after slave address reading
            LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];  //e. send another byte
            LPC_I2C0->CONCLR = I2CONCLR_SIC;	//e. clear interrupt bit
            break;

        case 0x28:	//e. Regardless it's a ACK after data byte
            if  (WrIndex == I2C_WRITELENGTH) { //e. we have transmitted the data for the B potentiometer
                I2CMasterState = I2C_IDLE;
                LPC_I2C0->CONSET = I2CONSET_STO;      //e. Set Stop flag
                Output.Str.Cnt_Dif = 300;
            } else if (WrIndex == 3) {
                LPC_I2C0->CONSET = I2CONSET_STA;
                Output.Str.Cnt_Dif = 200;
            } else {
                LPC_I2C0->DAT = I2CMasterBuffer[WrIndex++];  //e. send another byte
                Output.Str.Cnt_Dif = 100;
            }
            LPC_I2C0->CONCLR = I2CONCLR_SIC;	//e. clear interrupt bit
            break;

        case 0x20:							  //e. no aknowledgement after address transmitting
        case 0x30:							  //e. no aknowledgement after data block transmitting
            LPC_I2C0->CONSET = I2CONSET_STO;      //e. Set Stop flag
            LPC_I2C0->CONCLR = (I2CONCLR_SIC | I2CONCLR_STAC);
            I2CMasterState = I2C_IDLE;	  //e. fix new state
            break;
    }
    return;
}
/******************************************************************************
** Function name:		DAC_ADC_Exchange
**
** Descriptions:		Loading data to DACs and initialization of ADC reading
**
** parameters:			None
** Returned value:		None
**
******************************************************************************/
void DAC_ADC_Exchange()
{
    //-------------------------loading data from ADC to buffer---------------------------------------
//int x;
    ExchangeErr &= ~ADC_ERR_MSK;		   //e. �������� ���� ������
    if (LPC_SSP0->SR & SSP_BUSY) {   		   //e. ���� ����� ����������� �� �����
        ExchangeErr |= ADC_ERR_MSK;		   //e. ���������� ���� ������
    } else {
        LPC_SSP0->DR =  0x8001; //�������� 0x8001 � ������� ��������.
        if (Sys_Clock & 1) { //���� �������� ���� ��
            LPC_SSP0->DR = WRITE_DAC0;   					//e.������� ��� ���_0 ����������.
            LPC_SSP0->DR = (-Output.ArrayOut[3]+32767);  	//e. �������� 12 ���
        } else { //���� ���� ������.
            LPC_SSP0->DR = WRITE_DAC1 ;   					//e.������� ��� ���_1 ����������.
            LPC_SSP0->DR = (Output.ArrayOut[0]<<1) & 0xFFF0; 		//e. �������� 12 ���
        }
    }
}
/******************************************************************************
** Function name:		ADC_Input
**
** Descriptions:		Reading data from ADC
**
** parameters:			None
** Returned value:		None
**
******************************************************************************/
void ADC_Input()
{
    uint32_t Dummy;

    //---------------------read data from ADC buffer---------------------------------------------
    Dummy = Dummy;
    ExchangeErr &= ~ADC_ERR_MSK;

    if (LPC_SSP0->SR & SSP_BUSY) {  					//���� ����� ���� �� ������(�������� ������)
        ExchangeErr |= ADC_ERR_MSK;         //���������� ���� ������

        if (!(LPC_SSP0->SR & TX_SSP_EMPT))			//����� �������� �� ����.
            ExchangeErr |= ADC_ERR_MSK;         //���������� ���� ������
    } else {						 					//����� �������� ��������� �����.
        Input.ArrayIn[0] = LPC_SSP0->DR;		 //������Thermo2
        Input.ArrayIn[1] = LPC_SSP0->DR;		//������ Thermo1
        Input.ArrayIn[2] = LPC_SSP0->DR;		//������ HF_out

        while (LPC_SSP0->SR & RX_SSP_notEMPT)  		//���� ����� SPI �� ����.
            Dummy = LPC_SSP0->DR;	                   //�������� �����.
    }


}
/*****************************************************************************
** Function name:		DAC_Output
**
** Descriptions:		Output data to intrnal DAC
**
** parameters:			output - code for output
** Returned value:		None
**
*****************************************************************************/
void DAC_Output(int output)
{
    LPC_DAC->CR = (output<<6);
    return;
}
/******************************************************************************
** Function name:		G_Photo_Init
**
** Descriptions:		Initialization of exchange with digital potentiometers
**
** parameters:			None
** Returned value:		None
**
******************************************************************************/
void G_Photo_Init(void )
{
    LPC_SC->PCONP |= (1 << 19);//��������� ���������� I2C.

    /* set PIO0.27 and PIO0.28 to I2C0 SDA and SCK */
    /* function to 01 on both SDA and SCK. */
    LPC_PINCON->PINSEL1 &= ~0x03C00000; //P0.27 - SDA.
    LPC_PINCON->PINSEL1 |= 0x01400000;	//P0.28 - SCK.

    //                   �������������     ����           ����        ����������
    /*����� ������          �����    ���������� I2C      ������      ���������� I2C    */
    LPC_I2C0->CONCLR = I2CONCLR_AAC | I2CONCLR_SIC | I2CONCLR_STAC | I2CONCLR_I2ENC;   // ��������� ���������������� � ����� �������

    /*--- Reset registers ---*/
    LPC_I2C0->SCLL   = I2SCLL_SCLL; // - ������� scl low time period
    LPC_I2C0->SCLH   = I2SCLH_SCLH; // - ������� scl high time period

    I2CMasterBuffer[0] = A_ADDRESS;  //���� ������������� ������ �
    I2CMasterBuffer[1] = WRITE_CMD;  //������
    I2CMasterBuffer[3] = B_ADDRESS;  //���� ������������� ������ �
    I2CMasterBuffer[4] = WRITE_CMD;  //������

    LPC_I2C0->CONSET = I2CONSET_I2EN; //��������� ���������� I2C.

}
/******************************************************************************
** Function name:		DAC_ADC_Exchange_Init
**
** Descriptions:		Initialization of data exchange with DACs and ADCs
**
** parameters:			None
** Returned value:		None
**
******************************************************************************/
void DAC_ADC_Exchange_Init()
{

    int Dummy; // ������������� ������� ��� ������� ������ ������.
    Dummy = Dummy;

    /* Enable AHB clock to the SSP0, SSP1 */
    LPC_SC->PCONP |= (0x1<<21); // ��������� SSP0.
// LPC_SC->PCONP |= (0x1<<10);

    /* ����� ������� ��� ��������� ���������� �� ��������� � ��������� �������� �� 4 */
    LPC_SC->PCLKSEL1 &= ~(0x3<<10);	//00 CLK/4;	1 CLK; 2 CLK/2; 3 CLK/8
    LPC_SC->PCLKSEL1 |= (0x0<<10);	//00 CLK/4;	1 CLK; 2 CLK/2; 3 CLK/8
// LPC_SC->PCLKSEL0 &= ~(0x3<<20);

    // P0.15~0.18 as SSP0
    LPC_PINCON->PINSEL0 &= ~(0x3UL<<30);  //��������� � 0.15
    LPC_PINCON->PINSEL0 |=  (0x2UL<<30);  //��� (???? SCK 0 ???). ������� ��� �������������� Master - slave

    LPC_PINCON->PINSEL1 &= ~((0x3<<0)|(0x3<<2)|(0x3<<4)); // �����������   � 0.17    �   � 0.18
    LPC_PINCON->PINSEL1 |=  ((0x2<<2)|(0x2<<4));	        //    ���         MISO0    �    MOSI0

    LPC_PINCON->PINMODE0 &= ~(0x3UL<<30);// ?  ������������ �� � 0.15 ������ On-Chip pull-down resistor enabled
    LPC_PINCON->PINMODE0 |=  (0x3UL<<30);// ?  ������������ �� � 0.15 ������ On-Chip pull-down resistor enabled

    LPC_PINCON->PINMODE1 &= ~((0x3<<2)|(0x3<<4));// ?  ������������ �� � 0.17 � � 0.18 ������ On-Chip pull-down resistor enabled
    LPC_PINCON->PINMODE1 |=  ((0x3<<2)|(0x3<<4));// ?  ������������ �� � 0.17 � � 0.18 ������ On-Chip pull-down resistor enabled

    /* P0.6~0.9 as SSP1 */
    /*  LPC_PINCON->PINSEL0 &= ~((0x3<<12)|(0x3<<14)|(0x3<<16)|(0x3<<18));
      LPC_PINCON->PINSEL0 |=  ((0x2<<12)|(0x2<<14)|(0x2<<16)|(0x2<<18));
      LPC_PINCON->PINMODE0 &= ~((0x3<<16)|(0x3<<12)|(0x3<<14)|(0x3<<18));
      LPC_PINCON->PINMODE0 |= ((0x3<<16)|(0x3<<14)|(0x3<<18));	 */

    /* Set DSS data to 16-bit, Frame format TI, SCR is 2 */
    LPC_SSP0->CR0 = ((3<<8)|(0<<7)|(0<<4) |0xF); // (0xF)-������������ DSS(Data sise select) � 16-������ ������, (3<<8 scr - ����� �������),
    //   ������ ������� ����� ������������ ����� �������, ������������ �������� � ������� ���������� ��������� �������
    //    ������ ����� TI.
    //  LPC_SSP1->CR0 = 0x0207;

    /* SSPCPSR clock prescale register, master mode, minimum divisor is 0x02 */
    LPC_SSP0->CPSR = 0x2;	  // freq = CLK/(cpsdvr*(scr+1)) = 1.6 MHz
// LPC_SSP1->CPSR = 0x2;

    /*SSP enable, master mode	   */
    LPC_SSP0->CR1 = SSPCR1_SSE;
//  LPC_SSP1->CR1 = SSPCR1_SSE;

    while (LPC_SSP0->SR & SSP_BUSY);
//  while (LPC_SSP1->SR & SSP_BUSY);

    while (LPC_SSP0->SR & RX_SSP_notEMPT)  /* clear the RxFIFO */
        Dummy = LPC_SSP0->DR;
    //all pins after reset is in GPIO mode, so CS pins needn't to configure
    LPC_GPIO0->FIODIR |= ADC;		// P0.16 defined as CS for ADC
    LPC_GPIO0->FIOSET |= ADC;		// set CS for ADC

    LPC_GPIO0->FIODIR |= DAC;		// P defined as CS for DAC
    LPC_GPIO0->FIOCLR |= DAC;		// set CS for DAC
    /*   while (LPC_SSP1->SR & RX_SSP_notEMPT)
    	Dummy = LPC_SSP1->DR;*/		/* clear the RxFIFO */
}
/*****************************************************************************
** Function name:		DACInit
**
** Descriptions:		initialize DAC channel
**
** parameters:			None
** Returned value:		None
**
*****************************************************************************/
void DACInit( void )
{
    /* setup the related pin to DAC output */
    LPC_PINCON->PINSEL1 |= 0x00200000;	/* ���������� p0.26  ��� ����� ��� */
// LPC_GPIO0->FIODIR |= (1<<26);
    LPC_DAC->CNTVAL = 0;               // ������� ���������
    LPC_DAC->CTRL = 0;	               // ���  ���
    return;
}
/******************************************************************************
** Function name:		Out_G_photo
**
** Descriptions:		Start of potentiometer data writing process
**
** parameters:			pointer to gain factors
** Returned value:		None
**
******************************************************************************/
void  Out_G_photo(uint32_t Ph_A, uint32_t Ph_B)
{
    I2CMasterBuffer[2] = Ph_A;// ������ � ����� I2C ������� ������ � � ������ ���� �������.(��������)
    I2CMasterBuffer[5] = Ph_B;// ������ � ����� I2C ������� ������ � � ������ ���� �������.(��������)

    LPC_I2C0->CONSET = I2CONSET_STA;	// ���������� ����� ����.
    I2CMasterState = I2C_BUSY;  // ���������� ���� ������� ����.
}

