#include "Serial_Libr.h"
#include "mbed.h"

/*
Serial Library .cpp

Version     : 1.00
Update date : 2019/3/17
Designer    : Watanabe Yuuto
*/

Serial_Libr::Serial_Libr(PinName _tx, PinName _rx ) : serial(_tx, _rx){
}

void Serial_Libr::setup(char start_ad ,char end_ad ,char read_byts ,char send_byts ,int Baud){
    START_ADDRESS = start_ad;
    END_ADDRESS = end_ad;
    READ_BYTS = read_byts;
    SEND_BYTS = send_byts;
    serial.baud(Baud);
}

bool Serial_Libr::read(unsigned char *read_data){
    miss = 0;
    chksum = 0;
    while( cah_data()!= START_ADDRESS ){
        miss++;
        if( miss > 10 )return false;
    }
    for(i = 0;i < READ_BYTS - 1 ;i++){
        get_data[i] = cah_data();
        if( i < READ_BYTS - 3 )chksum += get_data[i];
    }
    if( ( get_data[READ_BYTS - 2] == END_ADDRESS ) && ( get_data[READ_BYTS - 3] == chksum ) ){
       for(i = 0;i < READ_BYTS - 3;i++)read_data[i] = get_data[i];
       return true;
    }else return false;
}

void Serial_Libr::send(unsigned char *send_data){
    chksum = 0;
    serial.putc(START_ADDRESS);
    for(i = 0;i < SEND_BYTS - 3;i++){
        serial.putc(send_data[i]);
        chksum += send_data[i];
    }
    serial.putc(END_ADDRESS);
    serial.putc(chksum);
    wait_ms(7);
}

unsigned char Serial_Libr::cah_data(){
        timer.start();
        timer.reset();
        while(timer.read_ms() < 10){
          if(serial.readable()){
              return serial.getc();
          }
        }
        return 0;
    }

