#include "imaginator.h"
void superDisplay()
{
    HX8340S_LCD lcd( p9, p14, p13, p11);
    lcd.Initialize();
    lcd.ClearScreen();
}
void superSd(unsigned char*buffer,unsigned int *offset,int bytes,const char *path)
{
     SDFileSystem sd(p11, p12, p13, p8, "sd"); // the pinout on the mbed Cool Components workshop board
     FILE *fp =fopen(path, "r");
   
    if(fp == NULL) {
        error("Could not open file\c\n");
    }
    fseek(fp, *offset,SEEK_SET);
    *offset=*offset+bytes;
    fread((char*)buffer,1,bytes,fp);
    fclose(fp); 
     return;
}
void colorCompute(unsigned char*buffer, int* colorBuffer,int sizeOfBuffer)
{
    int j=0;
    for(int i=0;i<sizeOfBuffer;i=i+4)
    {
        colorBuffer[j]=RGB((buffer[i+2]),(buffer[i+1]),(buffer[i]));
        j++;
    }
    return;
}
void pickUpLine(unsigned char*buffer, int* colorBuffer,int sizeOfBuffer,int sizeOfLine,const char *path, unsigned int *absPtr)
{
    superSd(buffer,absPtr,sizeOfBuffer,path);
    colorCompute(buffer,colorBuffer,sizeOfBuffer);
    return;
}
void drawLine(int* color,int y)
{
    HX8340S_LCD lcd(p9, p14, p13, p11);
    DigitalOut scr(p9);
    scr=0;
    int k=0;
    for(int j=y;j<(16+y);j++)
    {    
        for(int i=0;i<220;i++)
        {
            lcd.DrawPixel(i,j,color[k]);
            k++;
        }
    }
    scr=1;
    return;
}
void bmpFromSDToScreen(const char* path)
{
    unsigned char rawbytes[14080];
    int color[3520];
    unsigned int absPtr=54;
    superDisplay();
    for(int i=0;i<176;i=i+16)
    {
        pickUpLine(rawbytes,color,14080,3520,path,&absPtr);
        drawLine(color,i);
    }
    return;
}