#ifndef Shot_H
#define Shot_H

#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include "Bitmap.h"
/** Shot Class
@brief Library for one of the objects Shot of spaceship, University of Leeds
@author Li Ruofan
@date May 2020
*/

class Shot{

public:
    /** Constructor */
    Shot();
    
    /** Destructor */
    ~Shot();
    
    /** Initialize the position and the size of the Shot
     * @param the value of horizontal position x (int)
     * @param the value of vertical position x (int)
     * @param the number of columns of Shot image (int)
     * @param the number of rows of Shot image (int) 
     */
    void init(int x,int y,int sizeX,int sizeY);
    
    /** draw the image of the Shot
     * @param lcd (N5110)
     */
    void draw(N5110 &lcd);  //draw the Shot
    
    /** Update the position of the Shot */   
    void update();
    
    /** get the position of Shot in the lcd
     * @return the current postion of Shot
     */ 
    Vector2D getPos();
private:
    int _x;
    int _y;
    int _width;
    int _height;
};
#endif