#ifndef spaceship_H
#define spaceship_H

#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include "Bitmap.h"
/* spaceship Class
@Library for Spaceship object in the spaceship project
@coded by Li Ruofan
@May 2020
*/
class Spaceship{

public: 
     /* Construct function of our ship*/
     Spaceship();
    
     /* Destruct function of our ship*/
     ~Spaceship();
    
    
    /* Initiate the position and the size of the ship
      @param the value of horizontal position x (int)
      @param the value of vertical position y (int)
      @param the columns of spaceship image (int)
      @param the rows of spaceship image (int) 
     */
    void init(int x,int y,int width,int height);
    
    /* draw the image of the ship
      @param lcd (N5110)
    */
    void draw(N5110 &lcd);
    
    void update();
    /// access and mutate
    
     /* get position and speed of spaceship in the lcd
       @return the current postion of spaceship
     */        
    void set_speed(Vector2D v);
    Vector2D get_speed();
    Vector2D get_Pos();
    
private:
    Vector2D _velocity;
    int _x;
    int _y;
    int _width;
    int _height;
    int _speed;

};
#endif