/* SPACE RACE Game using Arduino and Nokia 5110 LCD
 * Coded by: Ruofan Li
 * Date: 28-4-2020
 * Input -> Joystick (x0,y0)
*/

#include <spaceship.h> // Library for spaceship.cpp

//*Construct and Destruct
Spaceship::Spaceship()
{
 
}
 
Spaceship::~Spaceship()
{
 
}
 
void Spaceship::init(int x,int y,int width,int height)
{
    _x = x; //x value is fixed
    _y = y; //y is also fixed
    _width = width;
    _height = height;
    _speed = 4;
}

void Spaceship::draw(N5110 &lcd)
{
    // draw Spaceship in screen of N5110. 
int spaceship[] = {
   0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,0,0,0,0,
   0,0,0,0,1,1,0,0,0,0,
   0,0,1,1,0,0,1,1,0,0,
   0,1,1,1,1,1,1,1,1,0,
   0,1,1,1,1,1,1,1,1,0,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,0,0,1,1,1,1,
   0,1,1,1,0,0,1,1,1,0,
   0,0,1,1,0,0,1,1,0,0,
   0,0,0,1,1,1,1,0,0,0,
   0,0,0,0,0,0,0,0,0,0,
   
    Bitmap sprite(spaceship, _sizeX, _sizeY);
    sprite.render(lcd, _x, _y); 
};

void Spaceship::update(int d)
{

    if(d == 3){
        //turn right
        _x+=_speed;
        
        if(_x>75){
            
            _x = 75;
        }
    }else if(d == 7){
        //turn left
        _x-=_speed;
        
        if(_x<0) {
            _x = 0;
        }
    }
}

// get the position of the spaceship
Vector2D Spaceship::get_Pos()
{
    Vector2D p = {_x,_y};
    return p;
}