#include "homepage.h"

Homepage::homepage(){
    
}

Homepage::~homepage()
{}

void Homepage::welcome(N5110 &lcd,BusOut &output,Bgm &bgm) 
{
    //show "Spaceship"
    lcd.printString("   Spaceship   ",0,1);  
    lcd.refresh();
    drawEverything(lcd);
    lcd.refresh();
    output=0b000000;
    
    //welcome bgm
    bgm.welcome();
    output=0b111111;
    lcd.clear();
}
void Homepage::over(N5110 &lcd,BusOut &output) 
{
    //show game over
    lcd.printString(" You are failed ",0,1);   
    lcd.printString(" Press Start ",0,4);
    lcd.refresh();
    wait(1.0f);
    output=0b000000;
    wait(1.0f);
    output=0b111111;
    lcd.clear();
}
void Homepage::homepage(N5110 &lcd,InterruptIn &buttonA, InterruptIn &start,int *score,int n)
{
    //show Homepage and check the pressed button 
    lcd.refresh();
    while(1){
        
        lcd.printString(" Press Start to start ",0,0);
        lcd.printString(" A Rules",0,2);
        lcd.refresh();
        
        if(buttonA){
            wait(0.5f);
            lcd.clear(); 
            //show the game rule
            rules(lcd,buttonA);
        }else if(start){
            lcd.clear(); //start the game
            break;
        }
    }
    
}


void Homepage::displayCurScore(N5110 &lcd,int score){
    char buffer[4];
    sprintf(buffer,"%d",score);
    lcd.printString(buffer,0,0);
}
void Homepage::drawEverything(N5110 &lcd){
    
   int Spaceship[15][10] = {
   0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,1,1,0,0,0,0,
   0,0,0,0,1,1,0,0,0,0,
   0,0,1,1,0,0,1,1,0,0,
   0,1,1,1,1,1,1,1,1,0,
   0,1,1,1,1,1,1,1,1,0,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,1,1,1,1,1,1,
   1,1,1,1,0,0,1,1,1,1,
   0,1,1,1,0,0,1,1,1,0,
   0,0,1,1,0,0,1,1,0,0,
   0,0,0,1,1,1,1,0,0,0,
   0,0,0,0,0,0,0,0,0,0,
    //draw spaceship
    Bitmap sprite2(_Spaceship, 16, 10); 
    sprite2.render(lcd, 28, 28); 
}
void Homepage::rules(N5110 &lcd,InterruptIn &buttonA) {
    //show game rules
    while(1) {
        lcd.clear();
        lcd.printString("press X to fire",0,0);
        lcd.printString("use Joystick to move",0,1);
        lcd.printString("You need to destroy UFO",0,2);       
        lcd.printString("Don't let a UFO come near you",0,3);
        lcd.printString("Press B to go back",0,5);
        lcd.refresh();
        if(buttonB) {
            lcd.clear();
            wait(0.5f);
            return;
        }
    }
}
int homepage::again(N5110 &lcd,int score,InterruptIn &buttonX,InterruptIn &buttonY){
    
    lcd.clear();
    while(1){
        if(score>10){
            //if score > 10, player have enough POINTS to replay when he is defeated.
            lcd.printString("Play Again?",0,0);
            lcd.printString("Price: 10",0,2);
            lcd.printString("X Yes",0,3);
            lcd.printString("Y No",0,4);
            lcd.refresh();
            if(buttonX){
                wait(0.5f);
                lcd.clear();
                return -10;
            }else if(buttonY){
                wait(0.5f);
                lcd.clear();
                return 0;
            }
        }else{
            // player doesn't have enough scores , so game over directly
            lcd.printString("Fail",0,1);
            lcd.printString("Press Y return",0,2);
            lcd.refresh();
            if(buttonY){
                wait(0.5f);
                lcd.clear();
                return 0;
            }
        }
    }

}