/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Coded by Li Ruofan
Username:el17rl
StudentIDNumber:201199450
Date:5/10/2020
*/
#include <N5110.h>
#include <Joystick.h>
#include "shot.h"
#include "UFO.h"
#include "spaceship.h"
#include "homepage.h"
#include "bgm.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Joystick joystick(PTB10,PTB11,PTC16);
InterruptIn start(PTC5);
InterruptIn buttonX(PTC17);
InterruptIn buttonY(PTC12);
InterruptIn buttonA(PTB9);
InterruptIn buttonB(PTD0);
BusOut output(PTA1,PTA2,PTC2,PTC3,PTC4,PTD3); //leds
Bgm bgm;

UFO *UFO = NULL;
Shot *shots[5] = {NULL,NULL,NULL,NULL,NULL};
Spaceship *spaceship = NULL;

int score[3] = {0,0,0};
int curScore = 0;
int fail = 0;
int count = 0;

///////////// prototypes ///////////////
void attack();
void move(int signal);
void shoot();
void welcome();
void over();
void updateScore();
void over();
void init();
void updateGame();

///////////// functions ////////////////
int main(){
        
        init();
        while (1) {
        //welcome to the star war
        homepage->welcome(lcd,output,bgm);
        //choose different function
        homepage->homepage(lcd,buttonA,start,score,3);          
        spaceship = new Spaceship();
        spaceship->init(37,38,10,10);   
        while (start == 0){
            } 
            lcd.clear();

        }         
}
     
//updating the game 
void updateGame(){
    homepage->displayCurScore(lcd,curScore);
    Direction d = joystick.get_direction();
    spaceship->update(d);
    spaceship->draw(lcd);
    shoot();
    attack();
    lcd.clear();
}

// initialies buttons, lcd and joystick
void init(){
    buttonX.mode(PullDown);
    start.mode(PullDown);
    buttonA.mode(PullDown);
    buttonY.mode(PullDown);
    buttonB.mode(PullDown);
    joystick.init();       
    lcd.init();
    homepage = new Homepage();
}

//game over,
//clear data, bgm, etc.
void over(){
    bgm->died(bgm);
    homepage->over(lcd,output); 
    UFO = NULL;
    for(int i = 0;i<5;i++)shots[i] = NULL;
    fail = 0;
    count = 0;
    updateScore();
    curScore = 0;
}

//show the movement of the shot
//initialize the shot
//shot moves upwards until the UFO has been slained.
void shoot() {
    if (buttonX == 1) {
        for(int i = 0;i<5;i++){
            if(shots[i] == NULL){
                shots[i] = new shot();
                shots[i]->init(spaceship->getPos().x+3,35,5,3);
                break;
            }
        }
    } 
    for(int i = 0;i<5;i++){
        if(shots[i]!=NULL){
            shots[i]->draw(lcd);
            lcd.refresh();
            if(shots[i]->getPos().x>=UFO->getPos().x && shots[i]->getPos().x<=(UFO->getPos().x+12) && shots[i]->getPos().y<=(UFO->getPos().y+5)){ //being shot
                bgm.tone(750.0,0.1);
                shots[i] = NULL;
                UFO->setBlood(1);
                if(UFO->getBlood() <= 0){
                    UFO = NULL; //destroy 
                    curScore+=1;   //get score
                }             
            }else if(shots[i]->getPos().y<=0){
                shots[i] = NULL;
            }else {
                shots[i]->update();
            }
        }
    }
}

//display the movement of the UFO
//initialize the UFO
//UFO moves downwards until meets the spaceship
void attack() { 
    if(UFO == NULL){
        UFO = new UFO;
        UFO->init(12,5);
        UFO->draw(lcd);
        lcd.refresh();
    } else {
        UFO->update();
        if(UFO->getPos().y>=33){
            fail = 1;
        }else{
            UFO->draw(lcd);
            lcd.refresh();
        }
    }
}