#ifndef BGM_H
#define BGM_H
#include <bitset>

#include "mbed.h"
#include "N5110.h"

namespace mbed
{
class AnalogIn;
class InterruptIn;
class PwmOut;
class Timeout;
}
/*My bgm Class
@Library for bgm object in the spaceship project
@coded by Li Ruofan
@May 2020
*/

class Bgm
{

public:

    /** Constructor & Destructor */
    Bgm();
    
    ~Bgm();
    
    void tone(float frequency, float duration);
    /* Generate the bgm in the homepage: Chinese music "The East is Red" */
    void welcome();
    
    /* Generate a bgm in the battlefield: Australia music "sheep clipping" */
    void battlefield();
    
    /* Generate a bgm when the player is died: "London bridge is falling down" */
    void died();

private:
    void init_buttons();
    void tone_off();
    mbed::Timeout *_timeout;
    mbed::PwmOut   *_buzzer;

};

#endif