#include "bgm.h"

// construct & destruct/
bgm::bgm()
    :
    _timeout(new Timeout()),
    _buzzer(new PwmOut(PTC10))
{}

bgm::~bgm()
{
    
}

void Sound::tone(float frequency, float duration)
{
    _buzzer->period(1.0f/frequency);
    _buzzer->write(0.5);  // 50% duty cycle - square wave
    _timeout->attach(callback(this, &Sound::tone_off), duration );
}
// The number "1,2,3,4,5,6,7" means each number note in the notation

// Excerpted from famous Chinese and English songs
void bgm::welcome(){
    tone(784.0f,0.4f);
    wait(0.4f);
    tone(784.0f,0.1f);
    wait(0.1f);
    tone(880.0f,0.4f);
    wait(0.4f);
    tone(587.0f,0.8f);
    wait(0.8f);
    tone(523.0f,0.4f);
    wait(0.4f);
    tone(523.0f,0.1f);
    wait(0.1f);
    tone(440.0f,0.4f);
    wait(0.4f);
    tone(587.0f,0.8f);
    wait(0.8f);
    tone(784.0f,0.4f);
    wait(0.4f);
    tone(784.0f,0.4f);
    wait(0.4f);
    tone(880.0f,0.1f);
    wait(0.1f);
    tone(1046.0f,0.4f);
    wait(0.4f);
    tone(880.0f,0.2f);
    wait(0.2f);
    tone(784.0f,0.2f);
    wait(0.2f);
    tone(523.0f,0.4f);
    wait(0.4f);
    tone(523.0f,0.1f);
    wait(0.1f);
    tone(440.0f,0.1f);
    wait(0.1f);
    tone(587.0f,0.8f);
    wait(0.8f);
    
}

void bgm::battlefield(){
    tone(659.0f,0.3f);
    wait(0.3f);
    tone(659.0f,0.2f);
    wait(0.2f);
    tone(587.0f,0.3f);
    wait(0.3f);
    tone(523.0f,0.2f);
    wait(0.2f);
    tone(523.0f,0.3f);
    wait(0.3f);
    tone(659.0f,0.2f);
    wait(0.2f);
    tone(784.0f,0.3f);
    wait(0.3f);
    tone(1046.0f,0.3f);
    wait(0.3f);
    tone(1046.0f,0.2f);
    wait(0.2f);
    tone(1046.0f,0.2f);
    wait(0.2f);
    tone(880.0f,0.5f);
    wait(0.5f);
    tone(784.0f,0.3f);
    wait(0.3f);
    tone(784.0f,0.2f);
    wait(0.2f);
    tone(880.0f,0.3f);
    wait(0.3f);
    tone(784.0f,0.3f);
    wait(0.3f);
    tone(659.0f,0.2f);
    wait(0.2f);
    tone(523.0f,0.3f);
    wait(0.3f);
    tone(587.0f,0.3f);
    wait(0.3f);
    tone(587.0f,0.2f);
    wait(0.2f);
    tone(659.0f,0.3f);
    wait(0.3f);
    tone(587.0f,0.2f);
    wait(0.2f);
    
}

void bgm::died(){
    tone(784.0f,0.2f);
    wait(0.2f);
    tone(880.0f,0.3f);
    wait(0.3f);
    tone(784.0f,0.2f);
    wait(0.2f);
    tone(698.0f,0.3f);
    wait(0.3f);
    tone(659.0f,0.2f);
    wait(0.2f);
    tone(698.0f,0.3f);
    wait(0.3f);
    tone(784.0f,0.3f);
    wait(0.3f);
    tone(587.0f,0.3f);
    wait(0.3f);
    tone(784.0f,0.2f);
    wait(0.2f);
    tone(784.0f,0.3f);
    wait(0.3f);
    tone(659.0f,0.2f);
    wait(0.2f);
    tone(523.0f,0.3f);
    wait(0.3f);
    
}

void bgm::tone_off()
{
    // called after timeout
    _buzzer->write(0.0);
}
