#ifndef UFO_H
#define UFO_H

#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include "Bitmap.h"
/* UFO Class
@Library for UFO object in the spaceship project
@coded by Li Ruofan
@May 2020
*/
class UFO{

public:
    /* Constructor & Destructor */
    UFO();
    
    ~UFO();
     
    /* Initiate the position and the size of the UFO
      @param the value of horizontal position x (int)
      @param the value of vertical position y (int)
      @param the columns of UFO image (int)
      @param the rows of UFO image (int) 
     */
    void init(int x,int y,int _width,int _height);
    
    /* Get the position of UFO in lcd
      @return the position of UFO in lcd
     */
    Vector2D getPos();
    
    /* Update the position of UFO
     */
    void update();
    
    /* draw the image of the UFO
     * @param lcd (N5110)
     * @param the value difficulty mode (int)
     */
    void draw(N5110 &lcd,int mode);
    
    /** Set the UFO speed
     * @param the value of UFO speed
     */        
    void setSpeed(int speed);
    
    /** Get the speed of the UFO
     * @return the value of speed of the UFO (int)
     */
    int getSpeed();
    
    /** Get the blood of the UFO
     * @return the blood of the UFO
     */
    int getBlood();
    
    /** Set the blood of the UFO
     * @param the blood of the UFO
     */
    void setBlood(int harm);
    
private:
    int _x;
    int _y;
    int _width;
    int _height;
    int _speed;
    int _blood;
    
};
#endif