#ifndef BULLET_H
#define BULLET_H

#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include "Bitmap.h"
/** Bullet Class
@brief Library for one of the objects bullet of star war, University of Leeds
@author Huang Xinjie
@date May 2019
*/

class Bullet{

public:
    /** Constructor */
    Bullet();
    
    /** Destructor */
    ~Bullet();
    
    /** Initialize the position and the size of the bullet
     * @param the value of horizontal position x (int)
     * @param the value of vertical position x (int)
     * @param the number of columns of bullet image (int)
     * @param the number of rows of bullet image (int) 
     */
    void init(int x,int y,int sizeX,int sizeY);
    
    /** draw the image of the bullet
     * @param lcd (N5110)
     */
    void draw(N5110 &lcd);  //draw the bullet
    
    /** Update the position of the bullet */   
    void update();
    
    /** get the position of bullet in the lcd
     * @return the current postion of bullet
     */ 
    Vector2D getPos();
private:
    int _x;
    int _y;
    int _width;
    int _height;
};
#endif