#ifndef Homepage_H
#define Homepage_H

#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include "Bitmap.h"
#include "bgm.h"
/** Homepage Class
@brief Library for different pages in the screen of mbed, University of Leeds
@author Li Ruofan
@date May 2020
*/
class Homepage{

public:
    /** Constructor */
    Homepage();
    /** Destructor */
    ~Homepage();
    /** The welcome functions including lcd,leds and sound 
     * @param lcd (N5110)
     * @param stream of output bits to control leds (Busout)
     * @param the welcome song (Sound)
     */
    void welcome(N5110 &lcd,BusOut &output,Bgm &bgm);
    
    /** The over functions including lcd and leds
     * @param lcd (N5110)
     * @param a stream of output bits to control leds (Busout)
     */   
    void over(N5110 &lcd,BusOut &output);
    
    /** The over functions including lcd and leds
     * @param lcd (N5110)
     * @param the button A (InterruptIn)
     * @param the button B (InterruptIn)
     * @param the start button (InterruptIn)
     */  
    void homepage(N5110 &lcd,InterruptIn &buttonA,InterruptIn &buttonB, InterruptIn &start, int *score,int n);
    
    /** The rangking lists
     * @param lcd (N5110)
     * @param the vector of scores in the history (int)
     * @param the size of score vector (int)
     */    
   
    void displayCurScore(N5110 &lcd,int score);
    
    /** Draw images including a plane, a bullet and an enemy in the welcome page
     * @param lcd (N5110)
     * @param the value of score (int)
     */    
    void drawEverything(N5110 &lcd);
    
    
    /** Display rules of the game 
     * @param lcd (N5110)
     * @param the button B (InterruptIn)
     */ 
    void rules(N5110 &lcd,InterruptIn &buttonA,InterruptIn &buttonB);
    
    
    /**Play again the game when score > 10
     * Back when score <=10
     * @param lcd (N5110)
     * @param total score in one game (int)
     * @param the button X (InterruptIn)
     * @param the button Y (InterruptIn)
     * @return the score that need to be added to the previous one
     */     
    int again(N5110 &lcd,int score,InterruptIn &buttonX,InterruptIn &buttonY);
private:
};
#endif