#include "mbed.h"
#include <string>

DigitalOut P5(p5);
DigitalOut P6(p6);
DigitalOut P7(p7);
DigitalOut P8(p8);
DigitalOut P9(p9);
DigitalOut P10(p10);
DigitalOut P11(p11);
DigitalOut P12(p12);
DigitalOut P13(p13);
DigitalOut P14(p14);

AnalogIn P15(p15);
AnalogIn P16(p16);
AnalogIn P17(p17);
AnalogIn P18(p18);
AnalogIn P19(p19);
AnalogIn P20(p20);

PwmOut P21(p21);
PwmOut P22(p22);
PwmOut P23(p23);
PwmOut P24(p24);
PwmOut P25(p25);
PwmOut P26(p26);

DigitalOut P27(p27);
DigitalOut P28(p28);
DigitalOut P29(p29);
DigitalOut P30(p30);

PwmOut RED(LED1);
PwmOut BLUE(LED2);
PwmOut GREEN(LED3);
DigitalOut RGB(LED4);

Serial pc(p28, p27);
//Serial pc(USBTX, USBRX);

void receive();
void extractCommand(char *buffer, int &value); 
int power(int pow);
char temp[100];

int main() {
    
    RED = 1;
    GREEN = 1;
    BLUE = 1;
    RGB = 0;
    
    pc.baud(115200);
    
    pc.printf("\r\nWelcome to danBed communication v1.1!");
    pc.printf("\r\nWrite 'Labas' to continue...\r\n");
    
    GET:
    receive();
    string labas = "Labas";
    
    if (temp == labas) pc.printf("\r\nLabas!!!\r\n");
    else{ 
        pc.printf("\r\nTry again! Type 'Labas'...\r\n");
        goto GET;
    }
    
    delete &labas;
    
    while(1) {
        
        receive();
        char buffer[10];
        int value = 0;
        
        memset(buffer, 0, sizeof(buffer));
        extractCommand(buffer, value); 
        
        
        if(strcmp(buffer, "RGB") == 0){
            RGB = value;
            if(value == 1) pc.printf("\r\nRGB turned ON\r\n");
            else pc.printf("\r\nRGB turned OFF\r\n");
        }
        else if(strcmp(buffer, "RED") == 0){
            float tmp = ((float) (255 - value)) / 255;
            RED = tmp;
            pc.printf("\r\nRED value %i\r\n", value);
        }
        else if(strcmp(buffer, "GREEN") == 0){
            float tmp = ((float) (255 - value)) / 255;
            GREEN = tmp;
            pc.printf("\r\nGREEN value %i\r\n", value);
        }
        else if(strcmp(buffer, "BLUE") == 0){
            float tmp = ((float) (255 - value)) / 255;
            BLUE = tmp;
            pc.printf("\r\nBLUE value %i\r\n", value);
        }
        else if(strcmp(buffer, "P5") == 0){
            P5 = value;
            pc.printf("\r\nP5 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P6") == 0){
            P6 = value;
            pc.printf("\r\nP6 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P7") == 0){
            P7 = value;
            pc.printf("\r\nP7 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P8") == 0){
            P8 = value;
            pc.printf("\r\nP8 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P9") == 0){
            P9 = value;
            pc.printf("\r\nP9 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P10") == 0){
            P10 = value;
            pc.printf("\r\nP10 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P11") == 0){
            P11 = value;
            pc.printf("\r\nP11 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P12") == 0){
            P12 = value;
            pc.printf("\r\nP12 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P13") == 0){
            P13 = value;
            pc.printf("\r\nP13 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P14") == 0){
            P14 = value;
            pc.printf("\r\nP14 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P15") == 0){
            pc.printf("\r\nRead analog P15 value = %fV\r\n", (P15 * 3.3));
        }
        else if(strcmp(buffer, "P16") == 0){
            pc.printf("\r\nRead analog P16 value = %fV\r\n", (P16 * 3.3));
        }
        else if(strcmp(buffer, "P17") == 0){
            pc.printf("\r\nRead analog P17 value = %fV\r\n", (P17 * 3.3));
        }
        else if(strcmp(buffer, "P18") == 0){
            pc.printf("\r\nRead analog P18 value = %fV\r\n", (P18 * 3.3));
        }
        else if(strcmp(buffer, "P19") == 0){
            pc.printf("\r\nRead analog P19 value = %fV\r\n", (P19 * 3.3));
        }
        else if(strcmp(buffer, "P20") == 0){
            pc.printf("\r\nRead analog P20 value = %fV\r\n", (P20 * 3.3));
        }      
        else if(strcmp(buffer, "P21") == 0){
            float tmp = ((float) value) / 255;
            P21 = tmp;
            pc.printf("\r\nP21 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P22") == 0){
            float tmp = ((float) value) / 255;
            P22 = tmp;
            pc.printf("\r\nP22 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P23") == 0){
            float tmp = ((float) value) / 255;
            P23 = tmp;
            pc.printf("\r\nP23 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P24") == 0){
            float tmp = ((float) value) / 255;
            P24 = tmp;
            pc.printf("\r\nP24 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P25") == 0){
            float tmp = ((float) value) / 255;
            P25 = tmp;
            pc.printf("\r\nP25 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P26") == 0){
            float tmp = ((float) value) / 255;
            P26 = tmp;
            pc.printf("\r\nP26 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P27") == 0){
            P27 = value;
            pc.printf("\r\nP27 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P28") == 0){
            P28 = value;
            pc.printf("\r\nP28 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P29") == 0){
            P29 = value;
            pc.printf("\r\nP29 value %i\r\n", value);
        }
        else if(strcmp(buffer, "P30") == 0){
            P30 = value;
            pc.printf("\r\nP30 value %i\r\n", value);
        }
        else pc.printf("\r\nCommand not recognised!\r\n");
        //else if(receiver == "RED"){
            //pc.gets(
    }
}

void receive(){
    memset(temp, 255, sizeof(temp));
    char c;
    int i = 0;
    
    while(true){
        if(pc.readable()){
            c = pc.getc();
            if (c == 13){
                temp[i] = 0; 
                break;
            }
            else temp[i] = c;
            pc.putc(c);
            i++;
        }
    }
} 

void extractCommand(char *buffer, int &value){
    bool inNumber = false;
    int difference = 0;
    int number[10];
    for(int i = 0; i < 100; i++){       
        
        if(temp[i] == 0){
                value = 0;
                return;
        }      
        if(inNumber){
            if(temp[i] != 62){
                number[i - difference] = temp[i] - 48;    
            }
            else{
                value = 0;
                int decimals = i - difference;
                //pc.printf("\r\nNumber of decimals = %i", decimals);
                for(int i = 0; i < decimals; i++){
                    int temp = decimals - i - 1;
                    //pc.printf("\r\nTemp = %i Number = %i Power = %i", temp, number[i], power(temp));
                    value = value + (number[i] * power(temp));  
                    //pc.printf("\r\nValue = %i", value);          
                }
                //pc.printf("\r\nFinal value = %i", value);
                return;
            }
        }
        
        if((temp[i] != 60) && !(inNumber)){
            buffer[i] = temp[i];
        }
        else if(!(inNumber)){
            inNumber = true;
            difference = i + 1;
            //pc.printf("\r\nIn number, difference = %i", difference);
        }        
    }    
} 

int power(int pow){
    
    if(pow == 0) return 1;
    
    int rezult = 1;
    
    for(int i = 1; i <= pow; i++){
         rezult *= 10;
    }
    return rezult;
}
